CREATE VIEW partial_artifact_global_timeline AS 
SELECT 
    revisions.history_action_id,
    revisions.history_action_timestamp,
    revisions.history_action_user,
    revisions.max_revision_timestamp,
    revisions.min_revision_timestamp,
    revisions.artifact_id,
    revisions.foreign_entity,
    revisions.history_action_json
FROM
(
    SELECT 
        grouped_unionall._revision_action_id,
        grouped_unionall.min_revision_timestamp,
        grouped_unionall.max_revision_timestamp,
        grouped_unionall.artifact_id,
        grouped_unionall.foreign_entity,
        history_actions.history_action_id,
        history_actions.history_action_timestamp,
        history_actions.history_action_user,
        history_actions.history_action_json
    FROM
    (
        SELECT 
            unionall._revision_action_id,
            min(unionall._revision_timestamp) as min_revision_timestamp,
            max(unionall._revision_timestamp) as max_revision_timestamp,
            unionall.artifact_id,
            max(unionall.foreign_entity) AS foreign_entity
        FROM
        (
            SELECT 
                _revision_action_id,
                _revision_timestamp,
                artifact_id,
                0 AS foreign_entity
            FROM
                artifacts_history
            UNION ALL
            SELECT 
                _revision_action_id,
                _revision_timestamp,
                signoff_artifact_id,
                0 AS foreign_entity
            FROM 
                signoffs_history
            UNION ALL
            SELECT 
                _revision_action_id,
                _revision_timestamp,
                reference_relationship_artifact_id_from,
                0 AS foreign_entity
            FROM 
                reference_relationships_history
            UNION ALL
            SELECT 
                _revision_action_id,
                _revision_timestamp,
                reference_relationship_artifact_id_to,
                1 AS foreign_entity
            FROM 
                reference_relationships_history
            UNION ALL
            SELECT
                blueprint_versions_history._revision_action_id,
                blueprint_versions_history._revision_timestamp,
                artifacts_history_innerquery.artifact_id,
                0 AS foreign_entity
            FROM
            (
                SELECT 
                    _revision_action_id,
                    (_revision_json ->> 'operation') = 'DELETE' AS delete_rev,
                    _revision_timestamp AS current,
                    artifact_id,
                    artifact_json #>> '{blueprintVersionId,blueprintId}' AS blueprint_version_blueprint_id,
                    artifact_json #>> '{blueprintVersionId,versionId}' AS blueprint_version_version_id,
                    lag(_revision_timestamp, 1) OVER (PARTITION BY artifact_id ORDER BY _revision_timestamp DESC) AS next
                FROM 
                    artifacts_history
                ORDER BY _revision_timestamp DESC
            ) artifacts_history_innerquery
            JOIN blueprint_versions_history blueprint_versions_history
            ON blueprint_versions_history.blueprint_version_blueprint_id = artifacts_history_innerquery.blueprint_version_blueprint_id 
            AND blueprint_versions_history.blueprint_version_version_id = artifacts_history_innerquery.blueprint_version_version_id 
            AND artifacts_history_innerquery.delete_rev = false 
            AND (artifacts_history_innerquery.next IS NULL OR blueprint_versions_history._revision_timestamp < artifacts_history_innerquery.next) 
            AND blueprint_versions_history._revision_timestamp > artifacts_history_innerquery.current
        ) unionall
        GROUP BY unionall._revision_action_id, unionall.artifact_id
    ) grouped_unionall
    JOIN history_actions history_actions ON history_actions.history_action_id = grouped_unionall._revision_action_id
    ORDER BY history_actions.history_action_timestamp desc, grouped_unionall.max_revision_timestamp desc, grouped_unionall.artifact_id desc
) revisions;