<html lang="en">
<head>
    <meta charset="utf-8"> <meta name="viewport" content="width=device-width"> <meta http-equiv="X-UA-Compatible" content="IE=edge"> <title>DSS activity</title> <style>
        @import url('https://fonts.googleapis.com/css2?family=Source+Sans+3:ital,wght@0,200..900;1,200..900&display=swap');
    </style>
    <style type="text/css">
        /* ensure that clients don't add any padding or spaces around the email design and allow us to style emails for the entire width of the preview pane */
        body,
        #bodyTable {
            height: 100% !important;
            width: 100% !important;
            margin: 0;
            padding: 0;
            font-family: "Source Sans 3", Arial, sans-serif;
            background-color: #e0f7f6; /* Light teal background */
        }

        /* Ensures Webkit- and Windows-based clients don't automatically resize the email text. */
        body,
        table,
        td,
        p,
        a,
        li,
        blockquote {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
        }

         /* Forces Yahoo! to display emails at full width */
        .thread-item.expanded .thread-body .body,
        .msg-body {
            width: 100% !important;
            display: block !important;
        }

        /* Forces Hotmail to display emails at full width */
        .ReadMsgBody,
        .ExternalClass {
            width: 100%;
            /* Keeping the original background-color for this fix, though body bg is different */
            background-color: #f4f4f4;
        }

        /* Forces Hotmail to display normal line spacing. */
        .ExternalClass,
        .ExternalClass p,
        .ExternalClass span,
        .ExternalClass font,
        .ExternalClass td,
        .ExternalClass div {
            line-height:100%;
        }

        /* Resolves webkit padding issue. */
        table {
            border-spacing:0;
        }

        /* Resolves the Outlook 2007, 2010, and Gmail td padding issue, and removes spacing around tables that Outlook adds. */
        table,
        td {
            border-collapse:collapse;
            mso-table-lspace:0pt;
            mso-table-rspace:0pt;
        }

        /* Corrects the way Internet Explorer renders resized images in emails. */
        img {
            -ms-interpolation-mode: bicubic;
        }

        /* Ensures images don't have borders or text-decorations applied to them by default. */
        img,
        a img {
            border:0;
            outline:none;
            text-decoration:none;
        }

        /* Styles Yahoo's auto-sensing link color and border */
        .yshortcuts a {
            border-bottom: none !important;
        }

        /* General link style */
        a {
            color: #00B2A9; /* Teal link color */
            text-decoration: none; /* Optional: removing underline */
        }

        /* Specific style to ensure button text is white */
        a.btn-primary {
            color: #ffffff !important;
        }

        /* Apple Mail doesn't support max-width, so we use media queries to constrain the email container width. */
        @media only screen and (min-width: 801px) {
            .email-container {
             width: 600px !important; /* Using 600px like the new template's max-width */
            }
        }

        /* Custom styles for content */
        .email-wrapper { /* Not directly used in the table structure but defined */
            width: 100%;
            max-width: 600px;
            margin: 16px auto;
            padding: 20px;
        }

        ul {
            line-height: 1.6;
        }

        .logo-header {
            text-align: left;
            margin-bottom: 20px; /* Space below logo */
            padding: 0 10px; /* Add slight padding if needed */
        }

        .logo {
            max-width: 120px; /* Logo size from new template */
            height: auto;     /* Maintain aspect ratio */
            margin-bottom: 4px;
        }

        .banner { /* Defined but not used in this specific migration */
            width: 100%;
            max-width: 550px;
            margin: 8px auto;
            display: block;
        }

        .container {
            background-color: #ffffff; /* White content background */
            padding: 16px 32px 24px 32px; /* Padding from new template */
            border: 1px solid #00B2A9; /* Teal border */
            border-radius: 8px; /* Rounded corners */
            /* Note: border-radius has limited support in email clients */
        }

        .content {
            color: #333333; /* Dark gray text */
            line-height: 1.5; /* Line spacing */
            font-family: "Source Sans 3", Arial, sans-serif;
            font-size: 14px; /* Base font size */
        }

        .content h1 {
            font-family: 'Source Sans 3', Arial, sans-serif;
            font-size: 28px; /* Slightly smaller H1 than legacy */
            font-weight: 600; /* Bolder H1 */
            margin-top: 10px;
            margin-bottom: 16px;
            line-height: 1.3;
            color: #333333;
        }

        .content p {
           margin-bottom: 16px; /* Consistent paragraph spacing */
        }

        .object-display {
           padding-left: 10px; /* Indent the object display slightly */
           margin-top: 10px;
           margin-bottom: 20px; /* Space before button */
        }

        .object-display img {
            width: 20px; /* Icon size */
            height: 20px;
            vertical-align: middle;
            margin-right: 8px; /* Space between icon and text */
        }

        .object-display a,
        .object-display span {
            font-weight: bold; /* Bold object name */
            color: #00B2A9; /* Teal color for link */
        }
        .object-display span {
             color: #333333; /* Non-linked object name color */
        }


        .button-wrapper {
            width: 100%;
            text-align: center;
            padding-top: 10px; /* Adjusted spacing */
            padding-bottom: 10px; /* Adjusted spacing */
        }

        .button {
            display: inline-block;
            margin-top: 4px;
            margin-bottom: 12px;
            padding: 12px 24px; /* Button padding */
            text-decoration: none;
            border-radius: 32px; /* Pill-shaped button */
            font-weight: 500;
            text-align: center;
            /* Note: border-radius has limited support */
        }

        .btn-primary {
            background-color: #00B2A9; /* Teal button background */
            color: #ffffff !important; /* White text - !important needed */
            font-weight: 500;
        }

        .btn-secondary { /* Defined but not used in this migration */
            background-color: #ffffff;
            color: #00B2A9;
            border: 1px solid #00B2A9;
        }

        .footer {
            text-align: center;
            color: #888888; /* Footer text color */
            font-size: 12px;
            padding: 30px 10px 10px 10px; /* Footer padding */
            line-height: 1.5;
        }
         .footer a {
            color: #00B2A9; /* Teal links in footer */
            text-decoration: underline; /* Underline footer links for clarity */
         }

         .social-icons {
            width: fit-content;
            margin: 10px auto 20px auto; /* Center social icons */
         }
         .social-icons img {
             padding: 0 5px; /* Space between social icons */
             width: 24px; /* Uniform social icon size */
             height: 24px;
         }

    </style>
    </head>

<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0">
    <table border="0" cellpadding="0" cellspacing="0" width="100%" id="bodyTable">
        <tr>
            <td align="center" valign="top" style="padding: 10px;">
                <table align="center" border="0" cellpadding="0" cellspacing="0" width="100%" class="email-container" style="max-width: 600px;">
                    <tr>
                        <td height="20" style="font-size: 0; line-height: 0;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td> <div class="logo-header"> <a href="https://www.dataiku.com" target="_blank">
                                    <img src="https://dku-assets.s3.amazonaws.com/img/emailing/DataikuLogoTeal_2025.png" alt="Dataiku Logo" class="logo">
                                </a>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="container">
                                <div class="content">
                                    <h1>${title}</h1>

                                    <p>
                                     ${senderDisplayName} <#if senderEmail??>(<a href="mailto:${senderEmail}">${senderEmail}</a>)</#if> invited you to join a ${productLongName} ${objectType}.
                                    </p>
                                    <p>
                                     Click on the link below to access the ${productLongName} instance.
                                    </p>

                                    <div class="object-display">
                                        <img style="width: 20px; height: 20px; vertical-align: middle;" alt="${objectType} icon" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/${iconPath}">
                                        <#if studioExternalUrl?? && objectLink??>
                                            <a target="_blank" href="${objectLink}">
                                             &nbsp;${displayName}
                                            </a>
                                        <#else>
                                            <span>
                                             &nbsp;${displayName}
                                            </span>
                                        </#if>
                                    </div>

                                    <#if studioExternalUrl?? && objectLink??>
                                     <div class="button-wrapper">
                                         <a class="button btn-primary" href="${objectLink}" target="_blank">
                                             OPEN ${objectType?upper_case}
                                         </a>
                                     </div>
                                    </#if>
                                </div></div></td>
                    </tr>
                    <tr>
                        <td class="footer">
                            &copy; 2025 Dataiku | All rights reserved.<br>
                            902 Broadway, New York City, New York 10010, United States
                        </td>
                    </tr>
                    <tr>
                         <td style="text-align: center; padding-bottom: 10px; font-family: 'Source Sans 3', Arial, sans-serif; font-size: 12px; line-height: 18px;">
                            <a href="https://knowledge.dataiku.com/" target="_blank" style="color: #00B2A9; text-decoration: underline;">Dataiku Knowledge Base</a>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="social-icons">
                                <a target="_blank" href="https://www.facebook.com/dataiku"><img alt="Facebook" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/facebook.png" /></a>
                                <a target="_blank" href="https://www.linkedin.com/company/dataiku"><img alt="LinkedIn" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/linkedin.png" /></a>
                                <a target="_blank" href="https://twitter.com/dataiku"><img alt="Twitter" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/twitter.png" /></a>
                                <a target="_blank" href="https://www.instagram.com/dataiku"><img alt="Instagram" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/instagram.png" /></a>
                            </div>
                        </td>
                    </tr>
                     <tr>
                        <td height="20" style="font-size: 0; line-height: 0;">&nbsp;</td>
                    </tr>
                </table>
                </td>
        </tr>
    </table>
</body>
</html>