# Bootstrap code for custom code recipe __ID__

# Please also see the "recipe.json" file for more information


# import the classes for accessing DSS objects from the recipe
library(dataiku)

# Inputs and outputs are defined by roles. In the recipe's I/O tab, the user can associate one
# or more dataset to each input and output role, depending on the role characteristics.
# Roles need to be defined in the recipe.json, in the inputRoles and outputRoles fields.

# To  retrieve the datasets of an input role named 'input_A' as an array of dataset names:
input_A_names = dkuCustomRecipeInputNamesForRole('input_A_role')

# For example, you can read the first input_A_role dataset with
# df <- dkuReadDataset(input_A_names[1])

# For outputs, the process is the same:
output_A_names = dkuCustomRecipeOutputNamesForRole('main_output')

# The configuration consists of the parameters set up by the user in the recipe Settings tab.

# Parameters must be added to the recipe.json file so that DSS can prompt the user for values in
# the Settings tab of the recipe. The field "params" holds a list of all the params for wich the
# user will be prompted for values.

# The configuration is simply a map of parameters
config = dkuCustomRecipeConfig()

print(config["parameter_name"])