#' In a custom shiny webapp, retrieves the configuration for the webapp
#' as a dictionary
#'
#' Please see documentation about how to write custom webapps
#'
#' @export
dkuWebAppConfig <- function(){
    rSpec <- dku_remoterun__get_env_var("DKU_CUSTOM_WEBAPP_CONFIG")
    return(jsonlite::fromJSON(rSpec))
}

#' In a custom shiny webapp, retrieve the path of the plugin resource folder
#'
#' Please see documentation about how to write custom webapps
#'
#' @export
dkuWebAppResource <- function(){
    return(dku_remoterun__get_env_var("DKU_CUSTOM_RESOURCE_FOLDER"))
}
