/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util;

import com.dataiku.dss.shadelib.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;

public final class ContentTypeUtils {
    public static void ensureContentType(ContentType expected, ContentType found) throws ParseException {
        ContentTypeUtils.ensureContentType(expected, null, found);
    }

    public static void ensureContentType(ContentType expected, String subTypeSuffix, ContentType found) throws ParseException {
        if (found == null) {
            throw new ParseException("Missing HTTP Content-Type header");
        }
        if (expected.matches(found)) {
            return;
        }
        if (expected.getBaseType().equals(found.getBaseType()) && found.hasSubTypeSuffix(subTypeSuffix)) {
            return;
        }
        if (subTypeSuffix == null) {
            throw new ParseException("The HTTP Content-Type header must be " + expected.getType() + ", received " + found.getType());
        }
        throw new ParseException("The HTTP Content-Type header must be " + expected.getType() + " or have the +" + subTypeSuffix + " suffix, received " + found.getType());
    }

    private ContentTypeUtils() {
    }
}

