/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.path;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Tokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenizerFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.util.AttributeFactory;
import java.util.Map;

public class PathHierarchyTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "pathHierarchy";
    private final char delimiter;
    private final char replacement;
    private final boolean reverse;
    private final int skip;

    public PathHierarchyTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.delimiter = this.getChar(args2, "delimiter", '/');
        this.replacement = this.getChar(args2, "replace", this.delimiter);
        this.reverse = this.getBoolean(args2, "reverse", false);
        this.skip = this.getInt(args2, "skip", 0);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public PathHierarchyTokenizerFactory() {
        throw PathHierarchyTokenizerFactory.defaultCtorException();
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        if (this.reverse) {
            return new ReversePathHierarchyTokenizer(factory, this.delimiter, this.replacement, this.skip);
        }
        return new PathHierarchyTokenizer(factory, this.delimiter, this.replacement, this.skip);
    }
}

