/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.snowball;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import com.dataiku.dss.shadelib.org.tartarus.snowball.SnowballStemmer;
import java.io.IOException;
import java.util.Objects;

public final class SnowballFilter
extends TokenFilter {
    private final SnowballStemmer stemmer;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public SnowballFilter(TokenStream input, SnowballStemmer stemmer) {
        super(input);
        this.stemmer = Objects.requireNonNull(stemmer, "stemmer");
    }

    public SnowballFilter(TokenStream in, String name) {
        super(in);
        Objects.requireNonNull(name, "name");
        try {
            Class<SnowballStemmer> stemClass = Class.forName("com.dataiku.dss.shadelib.org.tartarus.snowball.ext." + name + "Stemmer").asSubclass(SnowballStemmer.class);
            this.stemmer = stemClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Invalid stemmer class specified: " + name, e);
        }
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                char[] termBuffer = this.termAtt.buffer();
                int length = this.termAtt.length();
                this.stemmer.setCurrent(termBuffer, length);
                this.stemmer.stem();
                char[] finalTerm = this.stemmer.getCurrentBuffer();
                int newLength = this.stemmer.getCurrentBufferLength();
                if (finalTerm != termBuffer) {
                    this.termAtt.copyBuffer(finalTerm, 0, newLength);
                } else {
                    this.termAtt.setLength(newLength);
                }
            }
            return true;
        }
        return false;
    }
}

