/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet.facetset;

import com.dataiku.dss.shadelib.org.apache.lucene.document.IntPoint;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.facetset.FacetSet;
import java.util.Arrays;

public class IntFacetSet
extends FacetSet {
    public final int[] values;

    public IntFacetSet(int ... values2) {
        super(IntFacetSet.validateValuesAndGetNumDims(values2));
        this.values = values2;
    }

    @Override
    public long[] getComparableValues() {
        return Arrays.stream(this.values).mapToLong(Long::valueOf).toArray();
    }

    @Override
    public int packValues(byte[] buf, int start) {
        int i = 0;
        int offset = start;
        while (i < this.values.length) {
            IntPoint.encodeDimension(this.values[i], buf, offset);
            ++i;
            offset += 4;
        }
        return this.values.length * 4;
    }

    @Override
    public int sizePackedBytes() {
        return this.dims * 4;
    }

    private static int validateValuesAndGetNumDims(int ... values2) {
        if (values2 == null || values2.length == 0) {
            throw new IllegalArgumentException("values cannot be null or empty");
        }
        return values2.length;
    }
}

