/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BulkScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LeafCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Matches;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchesUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScorerSupplier;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SegmentCacheable;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TwoPhaseIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import java.io.IOException;

public abstract class Weight
implements SegmentCacheable {
    protected final Query parentQuery;

    protected Weight(Query query) {
        this.parentQuery = query;
    }

    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context);
        if (scorerSupplier == null) {
            return null;
        }
        Scorer scorer = scorerSupplier.get(1L);
        TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        if (twoPhase == null ? scorer.iterator().advance(doc) != doc : twoPhase.approximation().advance(doc) != doc || !twoPhase.matches()) {
            return null;
        }
        return MatchesUtils.MATCH_WITH_NO_TERMS;
    }

    public abstract Explanation explain(LeafReaderContext var1, int var2) throws IOException;

    public final Query getQuery() {
        return this.parentQuery;
    }

    public abstract Scorer scorer(LeafReaderContext var1) throws IOException;

    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        final Scorer scorer = this.scorer(context);
        if (scorer == null) {
            return null;
        }
        return new ScorerSupplier(){

            @Override
            public Scorer get(long leadCost) {
                return scorer;
            }

            @Override
            public long cost() {
                return scorer.iterator().cost();
            }
        };
    }

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context);
        if (scorerSupplier == null) {
            return null;
        }
        scorerSupplier.setTopLevelScoringClause();
        return new DefaultBulkScorer(scorerSupplier.get(Long.MAX_VALUE));
    }

    public int count(LeafReaderContext context) throws IOException {
        return -1;
    }

    protected static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;
        private final DocIdSetIterator iterator;
        private final TwoPhaseIterator twoPhase;

        public DefaultBulkScorer(Scorer scorer) {
            if (scorer == null) {
                throw new NullPointerException();
            }
            this.scorer = scorer;
            this.iterator = scorer.iterator();
            this.twoPhase = scorer.twoPhaseIterator();
        }

        @Override
        public long cost() {
            return this.iterator.cost();
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
            collector.setScorer(this.scorer);
            DocIdSetIterator scorerIterator = this.twoPhase == null ? this.iterator : this.twoPhase.approximation();
            DocIdSetIterator competitiveIterator = collector.competitiveIterator();
            if (competitiveIterator == null && scorerIterator.docID() == -1 && min2 == 0 && max == Integer.MAX_VALUE) {
                DefaultBulkScorer.scoreAll(collector, scorerIterator, this.twoPhase, acceptDocs);
                return Integer.MAX_VALUE;
            }
            return DefaultBulkScorer.scoreRange(collector, scorerIterator, this.twoPhase, competitiveIterator, acceptDocs, min2, max);
        }

        static int scoreRange(LeafCollector collector, DocIdSetIterator iterator2, TwoPhaseIterator twoPhase, DocIdSetIterator competitiveIterator, Bits acceptDocs, int min2, int max) throws IOException {
            int doc;
            if (competitiveIterator != null && competitiveIterator.docID() > min2) {
                min2 = competitiveIterator.docID();
                min2 = Math.min(min2, max);
            }
            if ((doc = iterator2.docID()) < min2) {
                doc = doc == min2 - 1 ? iterator2.nextDoc() : iterator2.advance(min2);
            }
            if (twoPhase == null && competitiveIterator == null) {
                while (doc < max) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        collector.collect(doc);
                    }
                    doc = iterator2.nextDoc();
                }
            } else {
                while (doc < max) {
                    if (competitiveIterator != null) {
                        assert (competitiveIterator.docID() <= doc);
                        if (competitiveIterator.docID() < doc) {
                            competitiveIterator.advance(doc);
                        }
                        if (competitiveIterator.docID() != doc) {
                            doc = iterator2.advance(competitiveIterator.docID());
                            continue;
                        }
                    }
                    if ((acceptDocs == null || acceptDocs.get(doc)) && (twoPhase == null || twoPhase.matches())) {
                        collector.collect(doc);
                    }
                    doc = iterator2.nextDoc();
                }
            }
            return doc;
        }

        static void scoreAll(LeafCollector collector, DocIdSetIterator iterator2, TwoPhaseIterator twoPhase, Bits acceptDocs) throws IOException {
            if (twoPhase == null) {
                int doc = iterator2.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        collector.collect(doc);
                    }
                    doc = iterator2.nextDoc();
                }
            } else {
                int doc = iterator2.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                        collector.collect(doc);
                    }
                    doc = iterator2.nextDoc();
                }
            }
        }
    }
}

