/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.BadMessageException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpHeader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Attributes;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.ExtensionConfig;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketComponents;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal.WebSocketNegotiation;
import java.util.List;
import java.util.Set;

public class ServerUpgradeRequestImpl
extends Request.Wrapper
implements ServerUpgradeRequest {
    private final Request request;
    private final WebSocketNegotiation negotiation;
    private final Attributes attributes = new Attributes.Lazy();
    private boolean upgraded = false;

    public ServerUpgradeRequestImpl(WebSocketNegotiation negotiation, Request baseRequest) throws BadMessageException {
        super(baseRequest);
        this.negotiation = negotiation;
        this.request = baseRequest;
    }

    @Override
    public WebSocketComponents getWebSocketComponents() {
        return this.negotiation.getWebSocketComponents();
    }

    @Override
    public void upgrade(Attributes attributes) {
        this.attributes.clearAttributes();
        for (String name : attributes.getAttributeNameSet()) {
            this.attributes.setAttribute(name, attributes.getAttribute(name));
        }
        this.upgraded = true;
    }

    @Override
    public Object removeAttribute(String name) {
        if (this.upgraded) {
            return this.attributes.removeAttribute(name);
        }
        return super.removeAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object attribute) {
        if (this.upgraded) {
            return this.attributes.setAttribute(name, attribute);
        }
        return super.setAttribute(name, attribute);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.upgraded) {
            return this.attributes.getAttribute(name);
        }
        return super.getAttribute(name);
    }

    @Override
    public Set<String> getAttributeNameSet() {
        if (this.upgraded) {
            return this.attributes.getAttributeNameSet();
        }
        return super.getAttributeNameSet();
    }

    @Override
    public void clearAttributes() {
        if (this.upgraded) {
            this.attributes.clearAttributes();
        } else {
            super.clearAttributes();
        }
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.negotiation.getOfferedExtensions();
    }

    @Override
    public String getProtocolVersion() {
        String version = this.request.getHeaders().get(HttpHeader.SEC_WEBSOCKET_VERSION.asString());
        if (version == null) {
            return Integer.toString(13);
        }
        return version;
    }

    @Override
    public List<String> getSubProtocols() {
        return this.negotiation.getOfferedSubprotocols();
    }

    @Override
    public boolean hasSubProtocol(String subprotocol) {
        for (String protocol : this.getSubProtocols()) {
            if (!protocol.equalsIgnoreCase(subprotocol)) continue;
            return true;
        }
        return false;
    }
}

