/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.buffer;

import com.atilika.kuromoji.buffer.BufferEntry;
import com.atilika.kuromoji.io.ByteBufferIO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class TokenInfoBuffer {
    private static final int INTEGER_BYTES = 4;
    private static final int SHORT_BYTES = 2;
    private ByteBuffer buffer;
    private final int tokenInfoCount;
    private final int posInfoCount;
    private final int featureCount;
    private final int entrySize;

    public TokenInfoBuffer(InputStream is) throws IOException {
        this.buffer = ByteBufferIO.read(is);
        this.tokenInfoCount = this.getTokenInfoCount();
        this.posInfoCount = this.getPosInfoCount();
        this.featureCount = this.getFeatureCount();
        this.entrySize = this.getEntrySize(this.tokenInfoCount, this.posInfoCount, this.featureCount);
    }

    public BufferEntry lookupEntry(int offset) {
        int i;
        BufferEntry entry = new BufferEntry();
        entry.tokenInfos = new short[this.tokenInfoCount];
        entry.posInfos = new byte[this.posInfoCount];
        entry.featureInfos = new int[this.featureCount];
        int entrySize = this.getEntrySize(this.tokenInfoCount, this.posInfoCount, this.featureCount);
        int position = this.getPosition(offset, entrySize);
        for (i = 0; i < this.tokenInfoCount; ++i) {
            entry.tokenInfos[i] = this.buffer.getShort(position + i * 2);
        }
        for (i = 0; i < this.posInfoCount; ++i) {
            entry.posInfos[i] = this.buffer.get(position + this.tokenInfoCount * 2 + i);
        }
        for (i = 0; i < this.featureCount; ++i) {
            entry.featureInfos[i] = this.buffer.getInt(position + this.tokenInfoCount * 2 + this.posInfoCount + i * 4);
        }
        return entry;
    }

    public int lookupTokenInfo(int offset, int i) {
        int position = this.getPosition(offset, this.entrySize);
        return this.buffer.getShort(position + i * 2);
    }

    public int lookupPartOfSpeechFeature(int offset, int i) {
        int position = this.getPosition(offset, this.entrySize);
        return 0xFF & this.buffer.get(position + this.tokenInfoCount * 2 + i);
    }

    public int lookupFeature(int offset, int i) {
        int position = this.getPosition(offset, this.entrySize);
        return this.buffer.getInt(position + this.tokenInfoCount * 2 + this.posInfoCount + (i - this.posInfoCount) * 4);
    }

    public boolean isPartOfSpeechFeature(int i) {
        int posInfoCount = this.getPosInfoCount();
        return i < posInfoCount;
    }

    private int getTokenInfoCount() {
        return this.buffer.getInt(8);
    }

    private int getPosInfoCount() {
        return this.buffer.getInt(12);
    }

    private int getFeatureCount() {
        return this.buffer.getInt(16);
    }

    private int getEntrySize(int tokenInfoCount, int posInfoCount, int featureCount) {
        return tokenInfoCount * 2 + posInfoCount + featureCount * 4;
    }

    private int getPosition(int offset, int entrySize) {
        return offset * entrySize + 20;
    }
}

