/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.services.migration_paths.IBlueprintVersionMigrationPathsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BlueprintVersionMigrationPathsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IBlueprintVersionMigrationPathsService blueprintVersionMigrationPathsService;

    @AuditedCall(value={"msgType", "artifact-blueprint-version-migration-paths-list", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/blueprint-version-migration-paths/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BlueprintVersionMigrationPath> list(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.blueprintVersionMigrationPathsService.listBlueprintVersionMigrationPaths(authCtx, artifactId);
    }

    @AuditInline
    @RequestMapping(value={"/api/blueprint-version-migration-paths/apply"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ARTIFACT_TEMPLATE_UPDATE)
    @ResponseBody
    public void apply(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String blueprintVersionMigrationPathId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.blueprintVersionMigrationPathsService.applyBlueprintVersionMigrationPath(authCtx, artifactId, blueprintVersionMigrationPathId);
            this.auditTrailService.generic("artifact-template-update").with("artifactId", artifactId).with("blueprintVersionMigrationPathId", blueprintVersionMigrationPathId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("artifact-template-update", (Throwable)e).with("artifactId", artifactId).with("blueprintVersionMigrationPathId", blueprintVersionMigrationPathId).emit();
            throw e;
        }
    }
}

