/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.export.writers;

import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CustomPageExportWriter
implements Closeable {
    private final StringWriter writer = new StringWriter();
    private final CSVPrinter printer = new CSVPrinter((Appendable)this.writer, CSVFormat.DEFAULT);

    public InputStream getStream() {
        return IOUtils.toInputStream((CharSequence)this.writer.getBuffer(), (Charset)StandardCharsets.UTF_8);
    }

    public void writeRow(List<String> values) {
        try {
            this.printer.printRecord(values);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.printer.close();
    }
}

