/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.python_execution.autogovernance_script;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.services.python_execution.PythonScriptExecutionException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AutoGovernanceScriptException
extends PythonScriptExecutionException {
    private static final long serialVersionUID = -8647073971045022662L;

    public AutoGovernanceScriptException(String message, @Nullable EnrichedArtifact enrichedArtifact) {
        super(PythonScriptExecutionException.ScriptCodes.ERR_AUTOGOV_FAILED, AutoGovernanceScriptException.buildMessage(message, enrichedArtifact));
    }

    public AutoGovernanceScriptException(String message, @Nullable EnrichedArtifact enrichedArtifact, Throwable e) {
        super(PythonScriptExecutionException.ScriptCodes.ERR_AUTOGOV_FAILED, AutoGovernanceScriptException.buildMessage(message, enrichedArtifact), e);
    }

    private static String buildMessage(String message, @Nullable EnrichedArtifact enrichedArtifact) {
        StringBuilder sb = new StringBuilder();
        sb.append("An error occurred while running the auto-governance script");
        if (enrichedArtifact != null) {
            String blueprintVersionStr = StringUtils.equals((CharSequence)"bv.system.default", (CharSequence)enrichedArtifact.blueprintVersion.id.versionId) ? "Dataiku Standard" : (String)StringUtils.defaultIfBlank((CharSequence)enrichedArtifact.blueprintVersion.name, (CharSequence)"Unnamed");
            sb.append(" on ").append("item: ").append((String)StringUtils.defaultIfBlank((CharSequence)enrichedArtifact.artifact.name, (CharSequence)"Unnamed")).append(", ").append("item id: ").append(enrichedArtifact.artifact.id).append(", ").append("item type: ").append((String)StringUtils.defaultIfBlank((CharSequence)enrichedArtifact.blueprint.name, (CharSequence)"Unnamed")).append(", ").append("template: ").append(blueprintVersionStr);
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            sb.append(". ").append(System.lineSeparator()).append(message);
        }
        return sb.toString();
    }
}

