/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.storage.IItemBasedDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.QueryDslJdbcTemplate;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public abstract class AbstractItemBasedDAO<ID, TYPE, ENRICHEDTYPE>
extends AbstractPostgreSQLClient
implements IItemBasedDAO<ID, TYPE, ENRICHEDTYPE> {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.item-based-postgresql-client");
    @Autowired
    private IHistoryDataService historyDataService;

    protected abstract ID getId(TYPE var1);

    protected final String getItemName() {
        return this.getEntityType().entityName;
    }

    protected abstract EntityType getEntityType();

    protected abstract RowMapper<ENRICHEDTYPE> getRowMapper();

    protected abstract RelationalPathBase<?> getItemTablePath();

    protected abstract SimplePath<Object> getItemTableJsonColumnPath();

    protected abstract Predicate getIdCondition(ID var1);

    protected abstract RelationalPathBase<?> getHistoryTablePath();

    protected abstract SimplePath<Object> getHistoryRevisionColumnPath();

    protected abstract SimplePath<Object> getHistoryJsonColumnPath();

    protected boolean sqlExists(ID id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from(this.getItemTablePath())).where(this.getIdCondition(id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    public boolean exists(ID id) throws IOException {
        if (id == null) {
            return false;
        }
        try {
            return this.sqlExists(id);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    protected void sqlLock(ID id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from(this.getItemTablePath())).where(this.getIdCondition(id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    public void lock(ID id) throws IOException {
        try {
            this.sqlLock(id);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    protected int sqlCreate(TYPE item) {
        SQLInsertClause createQuery = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert(this.getItemTablePath()).columns(new Path[]{this.getItemTableJsonColumnPath()})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)createQuery);
    }

    @Override
    public void create(TYPE item) throws IOException {
        try {
            if (this.sqlCreate(item) != 1) {
                throw new DataStoreIOException("Cannot create " + this.getItemName() + ": " + String.valueOf(this.getId(item)));
            }
            this.createRevision(this.getId(item), RevisionType.ADD);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    protected int sqlSave(TYPE item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update(this.getItemTablePath()).set(this.getItemTableJsonColumnPath(), QueryBuilderUtils.toJsonb(item))).where(this.getIdCondition(this.getId(item)));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    public void save(TYPE item) throws IOException {
        try {
            if (this.sqlSave(item) != 1) {
                throw new DataStoreIOException("Cannot save " + this.getItemName() + ": " + String.valueOf(this.getId(item)));
            }
            this.createRevision(this.getId(item), RevisionType.UPDATE);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    protected int sqlDelete(ID id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete(this.getItemTablePath()).where(this.getIdCondition(id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    public void delete(ID id) throws IOException {
        try {
            if (!this.exists(id)) {
                throw new NotFoundException(this.getItemName() + " does not exist: " + String.valueOf(id));
            }
            this.createRevision(id, RevisionType.DELETE);
            if (this.sqlDelete(id) != 1) {
                throw new DataStoreIOException("Cannot delete " + this.getItemName() + ": " + String.valueOf(id));
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    protected SQLQuery<?> buildBaseSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(this.getItemTableJsonColumnPath()).from(this.getItemTablePath());
    }

    protected ENRICHEDTYPE sqlGet(ID id) {
        SQLQuery query = (SQLQuery)this.buildBaseSelectQuery().where(this.getIdCondition(id));
        return this.querydslJdbcTemplate.queryForObject(query, this.getRowMapper());
    }

    @Override
    public ENRICHEDTYPE getOrNull(ID id) throws IOException {
        try {
            return this.sqlGet(id);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public ENRICHEDTYPE getMandatory(ID id) throws IOException {
        ENRICHEDTYPE obj = this.getOrNull(id);
        if (obj == null) {
            throw new NotFoundException(this.getItemName() + " does not exist: " + String.valueOf(id));
        }
        return obj;
    }

    protected Stream<ENRICHEDTYPE> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildBaseSelectQuery(), this.getRowMapper());
    }

    @Override
    public Stream<ENRICHEDTYPE> listStream() throws IOException {
        try {
            return this.sqlListStream();
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<ENRICHEDTYPE> list() throws IOException {
        try (Stream<ENRICHEDTYPE> stream = this.listStream();){
            List list = stream.collect(Collectors.toList());
            return list;
        }
    }

    protected int sqlCreateRevision(ID id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(this.getItemTableJsonColumnPath()).from(this.getItemTablePath())).where(this.getIdCondition(id));
        SQLInsertClause insertRevision = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert(this.getHistoryTablePath()).set(this.getHistoryRevisionColumnPath(), QueryBuilderUtils.toJsonb(revision))).set(this.getHistoryJsonColumnPath(), (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insertRevision);
    }

    protected void createRevision(ID id, RevisionType revisionType) throws IOException {
        HistoryRevision revision = this.historyDataService.createRevision(revisionType, this.getEntityType());
        if (this.sqlCreateRevision(id, revision) != 1) {
            throw new DataStoreIOException("Cannot create revision for " + this.getItemName() + ": " + String.valueOf(id));
        }
    }

    protected SQLInsertClause batchCreateRevisions(String CTEName, RevisionType revisionType) throws IOException {
        HistoryRevision noIdRevision = this.historyDataService.createRevisionWithoutId(revisionType, this.getEntityType());
        return this.sqlBatchCreateRevisions(CTEName, this.getItemTableJsonColumnPath(), this.getHistoryTablePath(), this.getHistoryJsonColumnPath(), this.getHistoryRevisionColumnPath(), noIdRevision);
    }

    private SQLInsertClause sqlBatchCreateRevisions(String CTEName, SimplePath<Object> itemTableColumnPath, RelationalPathBase<?> historyTablePath, SimplePath<Object> itemHistoryColumnPath, SimplePath<Object> revisionHistoryColumnPath, HistoryRevision initialRevision) {
        String revisionSequenceName = "history_revisions_seq";
        String revisionIdColumnName = "revisionId";
        String revisionIdKeyName = "id";
        String initialRevisionColumnName = "initialRevision";
        String itemColumnName = ColumnMetadata.getName(itemTableColumnPath);
        SQLQuery itemsToUpdateNoIdRevision = (SQLQuery)this.sqlQueryFactory.select(new Expression[]{Expressions.as(QueryBuilderUtils.toJsonbAsExpression(initialRevision), (String)initialRevisionColumnName), SQLExpressions.nextval((String)revisionSequenceName).as(revisionIdColumnName), Expressions.stringTemplate((String)itemColumnName, (Object[])new Object[0])}).from((Expression)Expressions.stringTemplate((String)CTEName, (Object[])new Object[0]));
        SQLQuery itemsToUpdateWithIdRevision = (SQLQuery)this.sqlQueryFactory.select(new Expression[]{QueryBuilderUtils.jsonAddBuiltField(Expressions.stringTemplate((String)revisionIdColumnName, (Object[])new Object[0]), Expressions.stringTemplate((String)initialRevisionColumnName, (Object[])new Object[0]), revisionIdKeyName), Expressions.stringTemplate((String)itemColumnName, (Object[])new Object[0])}).from((Expression)itemsToUpdateNoIdRevision.as("itemsToUpdateNoIdRevision"));
        return (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert(historyTablePath).columns(new Path[]{revisionHistoryColumnPath, itemHistoryColumnPath})).select((SubQueryExpression)itemsToUpdateWithIdRevision);
    }

    protected void batchDelete(SQLDeleteClause sqlDeleteClause) throws IOException {
        try {
            String itemsToRevision = "items_to_revision";
            SQLBindings itemsDeleted = (SQLBindings)((SQLDeleteClause)sqlDeleteClause.addFlag(QueryFlag.Position.END, " RETURNING *")).getSQL().get(0);
            SQLBindings revisionCreationQuery = (SQLBindings)this.batchCreateRevisions(itemsToRevision, RevisionType.DELETE).getSQL().get(0);
            String deleteItemsAndStoreRevisions = String.format("WITH %s AS (%s)\n%s", itemsToRevision, itemsDeleted.getSQL(), revisionCreationQuery.getSQL());
            Object[] combinedBindingsInOrder = Stream.of(QueryDslJdbcTemplate.getBindingsObjArray(itemsDeleted), QueryDslJdbcTemplate.getBindingsObjArray(revisionCreationQuery)).flatMap(Arrays::stream).toArray();
            this.querydslJdbcTemplate.update(deleteItemsAndStoreRevisions, combinedBindingsInOrder);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }
}

