/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.sort.AbstractPropertyComparator;
import org.geotools.data.sort.CompositeComparator;
import org.geotools.data.sort.FidComparator;
import org.geotools.data.sort.IndexedPropertyComparator;
import org.geotools.data.sort.MergeSortDumper;
import org.geotools.data.sort.PropertyComparator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class SortedFeatureReader
implements SimpleFeatureReader {
    SimpleFeatureReader delegate;

    public static final boolean canSort(SimpleFeatureType schema, SortBy ... sortBy) {
        return MergeSortDumper.canSort(schema, sortBy);
    }

    public static int getMaxFeaturesInMemory(Query q) {
        return MergeSortDumper.getMaxFeatures(q);
    }

    public SortedFeatureReader(SimpleFeatureReader reader, Query query) throws IOException {
        this.delegate = MergeSortDumper.getDelegateReader(reader, query);
    }

    public SortedFeatureReader(SimpleFeatureReader reader, SortBy[] sortBy, int maxFeatures) throws IOException {
        this.delegate = MergeSortDumper.getDelegateReader(reader, sortBy, maxFeatures);
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.delegate.getFeatureType();
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        return (SimpleFeature)this.delegate.next();
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.delegate.hasNext();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public static Comparator<SimpleFeature> getComparator(SortBy ... sortBy) {
        return SortedFeatureReader.getComparator(sortBy, null);
    }

    public static Comparator<SimpleFeature> getComparator(SortBy[] sortBy, SimpleFeatureType schema) {
        if (sortBy == SortBy.UNSORTED || sortBy == null) {
            return null;
        }
        ArrayList<Comparator<SimpleFeature>> comparators = new ArrayList<Comparator<SimpleFeature>>();
        for (SortBy sb : sortBy) {
            AbstractPropertyComparator comparator;
            boolean ascending;
            if (sb == SortBy.NATURAL_ORDER) {
                comparators.add(new FidComparator(true));
                continue;
            }
            if (sb == SortBy.REVERSE_ORDER) {
                comparators.add(new FidComparator(false));
                continue;
            }
            String name = sb.getPropertyName().getPropertyName();
            boolean bl = ascending = sb.getSortOrder() == SortOrder.ASCENDING;
            if (schema == null) {
                comparator = new PropertyComparator(name, ascending);
            } else {
                int idx = schema.indexOf(name);
                comparator = new IndexedPropertyComparator(idx, ascending);
            }
            comparators.add(comparator);
        }
        if (comparators.size() == 1) {
            return (Comparator)comparators.get(0);
        }
        return new CompositeComparator(comparators);
    }
}

