/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReprojectingFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ReprojectingFeatureCollection
extends DecoratingSimpleFeatureCollection {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2(null);
    MathTransform transform;
    SimpleFeatureType schema;
    CoordinateReferenceSystem target;
    GeometryCoordinateSequenceTransformer transformer;

    public ReprojectingFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, CoordinateReferenceSystem target) {
        this(DataUtilities.simple(delegate), target);
    }

    public ReprojectingFeatureCollection(SimpleFeatureCollection delegate, CoordinateReferenceSystem target) {
        this(delegate, ((SimpleFeatureType)delegate.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem(), target);
    }

    public ReprojectingFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        this(DataUtilities.simple(delegate), source, target);
    }

    public ReprojectingFeatureCollection(SimpleFeatureCollection delegate, CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        super(delegate);
        this.target = target;
        SimpleFeatureType schema = (SimpleFeatureType)delegate.getSchema();
        this.schema = this.reType(schema, target);
        if (source == null) {
            throw new NullPointerException("source crs");
        }
        if (target == null) {
            throw new NullPointerException("destination crs");
        }
        this.transform = this.transform(source, target);
        this.transformer = new GeometryCoordinateSequenceTransformer();
    }

    public void setTransformer(GeometryCoordinateSequenceTransformer transformer) {
        this.transformer = transformer;
    }

    private MathTransform transform(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        try {
            return CRS.findMathTransform(source, target, true);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Could not create math transform", e);
        }
    }

    private SimpleFeatureType reType(SimpleFeatureType type, CoordinateReferenceSystem target) {
        try {
            return FeatureTypes.transform(type, target);
        }
        catch (SchemaException e) {
            throw new IllegalArgumentException("Could not transform source schema", e);
        }
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), this.features());
    }

    @Override
    public SimpleFeatureIterator features() {
        try {
            return new ReprojectingFeatureIterator(this.delegate.features(), this.transform, this.schema, this.transformer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        CoordinateReferenceSystem crs = this.getSchema().getCoordinateReferenceSystem();
        CoordinateReferenceSystem crsDelegate = ((SimpleFeatureType)this.delegate.getSchema()).getCoordinateReferenceSystem();
        if (crs != null) {
            DefaultCRSFilterVisitor defaulter = new DefaultCRSFilterVisitor(FF, crs);
            filter = (Filter)filter.accept((FilterVisitor)defaulter, null);
            if (crsDelegate != null && !CRS.equalsIgnoreMetadata(crs, crsDelegate)) {
                ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(FF, (FeatureType)this.delegate.getSchema());
                filter = (Filter)filter.accept((FilterVisitor)reprojector, null);
            }
        }
        return new ReprojectingFeatureCollection(this.delegate.subCollection(filter), this.target);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException("Not yet");
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T[])new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList list = new ArrayList();
        try (SimpleFeatureIterator i = this.features();){
            while (i.hasNext()) {
                list.add(i.next());
            }
            T[] TArray = list.toArray(a);
            return TArray;
        }
    }

    public boolean add(SimpleFeature o) {
        throw new UnsupportedOperationException("Not yet");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReferencedEnvelope getBounds() {
        try (SimpleFeatureIterator r = this.features();){
            Envelope newBBox = new Envelope();
            while (r.hasNext()) {
                SimpleFeature feature = (SimpleFeature)r.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom == null) continue;
                Envelope internal = geom.getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(newBBox, this.target);
            return referencedEnvelope;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while computing reprojected bounds", e);
        }
    }

    @Override
    protected boolean canDelegate(FeatureVisitor visitor) {
        return ReprojectingFeatureCollection.isGeometryless(visitor, this.schema);
    }

    public static boolean isGeometryless(FeatureVisitor visitor, SimpleFeatureType schema) {
        if (visitor instanceof FeatureAttributeVisitor) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(schema);
            for (Expression e : ((FeatureAttributeVisitor)visitor).getExpressions()) {
                e.accept((ExpressionVisitor)extractor, null);
            }
            for (PropertyName pname : extractor.getPropertyNameSet()) {
                AttributeDescriptor att = (AttributeDescriptor)pname.evaluate((Object)schema);
                if (!(att instanceof GeometryDescriptor)) continue;
                return false;
            }
            return true;
        }
        return visitor instanceof CountVisitor;
    }
}

