/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AbstractLazyAttributeTypeImpl;
import org.opengis.feature.Property;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

public abstract class AbstractLazyComplexTypeImpl
extends AbstractLazyAttributeTypeImpl
implements ComplexType {
    private Collection<PropertyDescriptor> descriptors;
    private Map<Name, PropertyDescriptor> descriptorMap;

    public AbstractLazyComplexTypeImpl(Name name, boolean identified, boolean isAbstract, List<Filter> restrictions, InternationalString description) {
        super(name, Collection.class, identified, isAbstract, restrictions, description);
    }

    public abstract Collection<PropertyDescriptor> buildDescriptors();

    private void requireDescriptors() {
        if (this.descriptors == null) {
            Collection<PropertyDescriptor> builtDescriptors = this.buildDescriptors();
            if (builtDescriptors == null) {
                this.descriptors = Collections.emptyList();
                this.descriptorMap = Collections.emptyMap();
            } else {
                ArrayList<PropertyDescriptor> localDescriptors = new ArrayList<PropertyDescriptor>(builtDescriptors);
                HashMap<Name, PropertyDescriptor> localDescriptorMap = new HashMap<Name, PropertyDescriptor>();
                for (PropertyDescriptor descriptor : localDescriptors) {
                    localDescriptorMap.put(descriptor.getName(), descriptor);
                }
                this.descriptors = Collections.unmodifiableCollection(localDescriptors);
                this.descriptorMap = Collections.unmodifiableMap(localDescriptorMap);
            }
        }
    }

    public Class<Collection<Property>> getBinding() {
        return super.getBinding();
    }

    public Collection<PropertyDescriptor> getDescriptors() {
        this.requireDescriptors();
        return this.descriptors;
    }

    public PropertyDescriptor getDescriptor(Name name) {
        this.requireDescriptors();
        return this.descriptorMap.get(name);
    }

    public boolean isInline() {
        return false;
    }

    @Override
    public String toString() {
        return "LazyComplexType: " + this.getName();
    }

    public PropertyDescriptor getDescriptor(String name) {
        this.requireDescriptors();
        PropertyDescriptor result = this.getDescriptor(new NameImpl(name));
        if (result == null && (result = this.getDescriptor(new NameImpl(this.getName().getNamespaceURI(), name))) == null) {
            for (PropertyDescriptor pd : this.descriptors) {
                if (!pd.getName().getLocalPart().equals(name)) continue;
                return pd;
            }
        }
        return result;
    }
}

