/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.style.GraphicalSymbol;

public class AbstractStyleVisitor
implements StyleVisitor {
    @Override
    public void visit(StyledLayerDescriptor sld) {
        for (StyledLayer sl : sld.getStyledLayers()) {
            if (sl instanceof UserLayer) {
                ((UserLayer)sl).accept(this);
                continue;
            }
            if (!(sl instanceof NamedLayer)) continue;
            ((NamedLayer)sl).accept(this);
        }
    }

    @Override
    public void visit(NamedLayer layer) {
        for (Style s : layer.getStyles()) {
            s.accept(this);
        }
        for (FeatureTypeConstraint ftc : layer.getLayerFeatureConstraints()) {
            ftc.accept(this);
        }
    }

    @Override
    public void visit(UserLayer layer) {
        for (Style s : layer.getUserStyles()) {
            s.accept(this);
        }
        for (FeatureTypeConstraint ftc : layer.getLayerFeatureConstraints()) {
            ftc.accept(this);
        }
    }

    @Override
    public void visit(FeatureTypeConstraint ftc) {
    }

    @Override
    public void visit(Style style) {
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            fts.accept(this);
        }
    }

    @Override
    public void visit(Rule rule) {
        for (Symbolizer sym : rule.symbolizers()) {
            sym.accept(this);
        }
    }

    @Override
    public void visit(FeatureTypeStyle fts) {
        for (Rule r : fts.rules()) {
            r.accept(this);
        }
    }

    @Override
    public void visit(Fill fill) {
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept(this);
        }
    }

    @Override
    public void visit(Stroke stroke) {
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept(this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept(this);
        }
    }

    @Override
    public void visit(Symbolizer sym) {
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        } else if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        } else if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        } else if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        } else if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        } else {
            throw new RuntimeException("visit(Symbolizer) unsupported");
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        if (ps.getDescription() != null) {
            ps.getDescription().accept(this);
        }
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept(this);
        }
    }

    @Override
    public void visit(LineSymbolizer line) {
        if (line.getDescription() != null) {
            line.getDescription().accept(this);
        }
        if (line.getStroke() != null) {
            line.getStroke().accept(this);
        }
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        if (poly.getDescription() != null) {
            poly.getDescription().accept(this);
        }
        if (poly.getDisplacement() != null) {
            poly.getDisplacement().accept(this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept(this);
        }
        if (poly.getStroke() != null) {
            poly.getStroke().accept(this);
        }
    }

    @Override
    public void visit(TextSymbolizer text) {
        if (text.getDescription() != null) {
            text.getDescription().accept(this);
        }
        if (text.getFill() != null) {
            text.getFill().accept(this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.getLabelPlacement() != null) {
            text.getLabelPlacement().accept(this);
        }
    }

    @Override
    public void visit(RasterSymbolizer raster) {
        if (raster.getChannelSelection() != null) {
            raster.getChannelSelection().accept(this);
        }
        if (raster.getColorMap() != null) {
            raster.getColorMap().accept(this);
        }
        if (raster.getContrastEnhancement() != null) {
            raster.getContrastEnhancement().accept(this);
        }
        if (raster.getDescription() != null) {
            raster.getDescription().accept(this);
        }
        if (raster.getImageOutline() != null) {
            raster.getImageOutline().accept(this);
        }
        if (raster.getShadedRelief() != null) {
            raster.getShadedRelief().accept(this);
        }
    }

    @Override
    public void visit(Graphic gr) {
        if (gr.getAnchorPoint() != null) {
            gr.getAnchorPoint().accept(this);
        }
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept(this);
        }
        for (GraphicalSymbol gs : gr.graphicalSymbols()) {
            if (gs instanceof Symbol) {
                ((Symbol)gs).accept(this);
                continue;
            }
            throw new RuntimeException("Don't know how to visit " + gs);
        }
    }

    @Override
    public void visit(Mark mark) {
        if (mark.getFill() != null) {
            mark.getFill().accept(this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept(this);
        }
    }

    @Override
    public void visit(ExternalGraphic exgr) {
    }

    @Override
    public void visit(PointPlacement pp) {
        if (pp.getAnchorPoint() != null) {
            pp.getAnchorPoint().accept(this);
        }
        if (pp.getDisplacement() != null) {
            pp.getDisplacement().accept(this);
        }
    }

    @Override
    public void visit(AnchorPoint ap) {
    }

    @Override
    public void visit(Displacement dis) {
    }

    @Override
    public void visit(LinePlacement lp) {
    }

    @Override
    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept(this);
        }
    }

    @Override
    public void visit(ColorMap colorMap) {
        for (ColorMapEntry cme : colorMap.getColorMapEntries()) {
            cme.accept(this);
        }
    }

    @Override
    public void visit(ColorMapEntry colorMapEntry) {
    }

    @Override
    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    @Override
    public void visit(ImageOutline outline) {
        if (outline.getSymbolizer() != null) {
            outline.getSymbolizer().accept(this);
        }
    }

    @Override
    public void visit(ChannelSelection cs) {
        if (cs.getGrayChannel() != null) {
            cs.getGrayChannel().accept(this);
        }
        if (cs.getRGBChannels() != null) {
            for (SelectedChannelType ch : cs.getRGBChannels()) {
                if (ch == null) continue;
                ch.accept(this);
            }
        }
    }

    @Override
    public void visit(OverlapBehavior ob) {
    }

    @Override
    public void visit(SelectedChannelType sct) {
        if (sct.getContrastEnhancement() != null) {
            sct.getContrastEnhancement().accept(this);
        }
    }

    @Override
    public void visit(ShadedRelief sr) {
    }
}

