/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.custompredict;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.custompredict.CustomPythonPredictionKernel;
import com.dataiku.lambda.endpoints.predictcommon.AbstractPythonPredictionStep;
import com.dataiku.lambda.endpoints.predictcommon.PipelineMessage;
import com.dataiku.lambda.model.api.PredictionResponse;
import com.dataiku.lambda.model.serverconfig.CustomPythonPredictionEndpointConfig;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomPythonPredictionStep
extends AbstractPythonPredictionStep {
    private final CustomPythonPredictionEndpointConfig ep;
    private final ServiceGenContext ctx;
    private final CustomPythonPredictionEndpointConfig.CustomModelType modelType;
    private final File codePath;
    private final List<String> resourceFolderPaths;
    private final List<String> userCodePaths;
    private CustomPythonPredictionKernel kernel;
    private ResponderKernelLink link;
    private AutoDelete kernelWorkDir;
    @Autowired
    private LambdaContext lambdaContext;
    @Autowired
    PasswordEncryptionService passwordEncryptionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.predict");

    public CustomPythonPredictionStep(CustomPythonPredictionEndpointConfig ep, ServiceGenContext ctx, CustomPythonPredictionEndpointConfig.CustomModelType modelType, File codePath, List<String> resourceFolderPaths, List<String> userCodePaths) {
        SpringUtils.getInstance().autowire((Object)this);
        this.ep = ep;
        this.ctx = ctx;
        this.modelType = modelType;
        this.codePath = codePath;
        this.resourceFolderPaths = resourceFolderPaths;
        this.userCodePaths = userCodePaths;
    }

    public void init() throws Exception {
        this.link = new ResponderKernelLink(SecretKeyGenerator.generate((int)16));
        File codeEnvFolder = this.ctx.getFileInEndpointFolder(this.ep.id, "python-env-live");
        this.kernelWorkDir = this.lambdaContext.getTempFolder("lambda-cust-pred-py-" + SecretKeyGenerator.generate((int)8));
        logger.infoV("Created temporary kernel work directory %s for service %s - endpoint %s - generation %s", new Object[]{this.kernelWorkDir.getAbsolutePath(), this.ctx.getServiceId(), this.ep.id, this.ctx.getGenerationId()});
        try {
            this.kernel = new CustomPythonPredictionKernel(this.link, this.ctx, this.ep.id, this.userCodePaths, codeEnvFolder, (File)this.kernelWorkDir, ApplicationConfigurator.isDevLambdaServer(), (GeneralSettingsDAO.CGrouppableProcessType)(ApplicationConfigurator.isDevLambdaServer() ? GeneralSettingsDAO.CGrouppableProcessType.LAMBDA_DEV_SERVER : null));
            this.kernel.start();
            CustomPythonPredictionKernel.StartRequest req = new CustomPythonPredictionKernel.StartRequest(this.modelType, this.codePath, this.resourceFolderPaths);
            CustomPythonPredictionKernel.StartResponse started = (CustomPythonPredictionKernel.StartResponse)this.link.execute((Object)req, CustomPythonPredictionKernel.StartResponse.class, "Failed to initiate custom model server");
            if (!started.ok) {
                throw new Exception("Failed to start custom prediction kernel: " + started.reason);
            }
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            IOException fe = this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            this.cleanupResources();
            throw fe;
        }
        catch (Exception e) {
            this.cleanupResources();
            throw e;
        }
    }

    protected void cleanupResources() {
        try {
            this.link.close();
            this.kernel.killWithoutMercy();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to cleanup custom prediction kernel", (Throwable)ex);
        }
        try {
            this.kernelWorkDir.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error cleaning kernel work directory", (Throwable)e);
        }
        this.link = null;
        this.kernel = null;
        this.kernelWorkDir = null;
    }

    @Override
    public PredictionResponse process(PipelineMessage message) throws Exception {
        AbstractPythonPredictionStep.PreparedRecords recs = this.toRecords(message, null, this.passwordEncryptionService);
        logger.trace(() -> "Sending query to kernel: " + JSON.json((Object)recs));
        AbstractPythonPredictionStep.InternalPredictionResponse iret = null;
        if (recs.serialized > 0) {
            try {
                logger.debugV("Sending request %s to kernel %s", new Object[]{recs.obj, this.kernel.getId()});
                iret = (AbstractPythonPredictionStep.InternalPredictionResponse)this.link.execute((Object)recs, AbstractPythonPredictionStep.InternalPredictionResponse.class, "Failed to run model");
                logger.debugV("Got response to request %s from kernel %s", new Object[]{recs.obj, this.kernel.getId()});
            }
            catch (SocketBlockLinkException e) {
                e.withLogTail((IDSSKernelBase)this.kernel);
                throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
        } else {
            iret = new AbstractPythonPredictionStep.InternalPredictionResponse();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Got kernel reply: " + JSON.json((Object)iret)));
        }
        PredictionResponse ret = this.toResponse(message, iret);
        ret.timing.functionInternal = iret.execTimeUS;
        return ret;
    }

    @Override
    public void destroy() {
        if (this.link != null) {
            try {
                this.link.close();
                this.kernel.killWithoutMercy();
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to cleanup custom prediction kernel", (Throwable)ex);
            }
        }
        if (this.kernel != null) {
            this.kernel.killNoWaitNoException(false);
        }
        if (this.kernelWorkDir != null) {
            this.kernelWorkDir.close();
        }
    }
}

