/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpStatelessAsyncServer;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.server.McpStatelessSyncServer;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.DefaultMcpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.McpUriTemplateManagerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;

public interface McpServer {
    public static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");

    public static SingleSessionSyncSpecification sync(McpServerTransportProvider transportProvider) {
        return new SingleSessionSyncSpecification(transportProvider);
    }

    public static AsyncSpecification<?> async(McpServerTransportProvider transportProvider) {
        return new SingleSessionAsyncSpecification(transportProvider);
    }

    public static StreamableSyncSpecification sync(McpStreamableServerTransportProvider transportProvider) {
        return new StreamableSyncSpecification(transportProvider);
    }

    public static AsyncSpecification<?> async(McpStreamableServerTransportProvider transportProvider) {
        return new StreamableServerAsyncSpecification(transportProvider);
    }

    public static StatelessAsyncSpecification async(McpStatelessServerTransport transport) {
        return new StatelessAsyncSpecification(transport);
    }

    public static StatelessSyncSpecification sync(McpStatelessServerTransport transport) {
        return new StatelessSyncSpecification(transport);
    }

    public static class SingleSessionSyncSpecification
    extends SyncSpecification<SingleSessionSyncSpecification> {
        private final McpServerTransportProvider transportProvider;

        private SingleSessionSyncSpecification(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        @Override
        public McpSyncServer build() {
            McpServerFeatures.Sync syncFeatures = new McpServerFeatures.Sync(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.completions, this.rootsChangeHandlers, this.instructions);
            McpServerFeatures.Async asyncFeatures = McpServerFeatures.Async.fromSync(syncFeatures, this.immediateExecution);
            McpAsyncServer asyncServer = new McpAsyncServer(this.transportProvider, this.jsonMapper == null ? McpJsonMapper.getDefault() : this.jsonMapper, asyncFeatures, this.requestTimeout, this.uriTemplateManagerFactory, this.jsonSchemaValidator != null ? this.jsonSchemaValidator : JsonSchemaValidator.getDefault());
            return new McpSyncServer(asyncServer, this.immediateExecution);
        }
    }

    public static class SingleSessionAsyncSpecification
    extends AsyncSpecification<SingleSessionAsyncSpecification> {
        private final McpServerTransportProvider transportProvider;

        private SingleSessionAsyncSpecification(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        @Override
        public McpAsyncServer build() {
            McpServerFeatures.Async features = new McpServerFeatures.Async(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.completions, this.rootsChangeHandlers, this.instructions);
            JsonSchemaValidator jsonSchemaValidator = this.jsonSchemaValidator != null ? this.jsonSchemaValidator : JsonSchemaValidator.getDefault();
            return new McpAsyncServer(this.transportProvider, this.jsonMapper == null ? McpJsonMapper.getDefault() : this.jsonMapper, features, this.requestTimeout, this.uriTemplateManagerFactory, jsonSchemaValidator);
        }
    }

    public static class StreamableSyncSpecification
    extends SyncSpecification<StreamableSyncSpecification> {
        private final McpStreamableServerTransportProvider transportProvider;

        private StreamableSyncSpecification(McpStreamableServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        @Override
        public McpSyncServer build() {
            McpServerFeatures.Sync syncFeatures = new McpServerFeatures.Sync(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.completions, this.rootsChangeHandlers, this.instructions);
            McpServerFeatures.Async asyncFeatures = McpServerFeatures.Async.fromSync(syncFeatures, this.immediateExecution);
            JsonSchemaValidator jsonSchemaValidator = this.jsonSchemaValidator != null ? this.jsonSchemaValidator : JsonSchemaValidator.getDefault();
            McpAsyncServer asyncServer = new McpAsyncServer(this.transportProvider, this.jsonMapper == null ? McpJsonMapper.getDefault() : this.jsonMapper, asyncFeatures, this.requestTimeout, this.uriTemplateManagerFactory, jsonSchemaValidator);
            return new McpSyncServer(asyncServer, this.immediateExecution);
        }
    }

    public static class StreamableServerAsyncSpecification
    extends AsyncSpecification<StreamableServerAsyncSpecification> {
        private final McpStreamableServerTransportProvider transportProvider;

        public StreamableServerAsyncSpecification(McpStreamableServerTransportProvider transportProvider) {
            this.transportProvider = transportProvider;
        }

        @Override
        public McpAsyncServer build() {
            McpServerFeatures.Async features = new McpServerFeatures.Async(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.completions, this.rootsChangeHandlers, this.instructions);
            JsonSchemaValidator jsonSchemaValidator = this.jsonSchemaValidator != null ? this.jsonSchemaValidator : JsonSchemaValidator.getDefault();
            return new McpAsyncServer(this.transportProvider, this.jsonMapper == null ? McpJsonMapper.getDefault() : this.jsonMapper, features, this.requestTimeout, this.uriTemplateManagerFactory, jsonSchemaValidator);
        }
    }

    public static class StatelessAsyncSpecification {
        private final McpStatelessServerTransport transport;
        McpUriTemplateManagerFactory uriTemplateManagerFactory = new DefaultMcpUriTemplateManagerFactory();
        McpJsonMapper jsonMapper;
        McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        McpSchema.ServerCapabilities serverCapabilities;
        JsonSchemaValidator jsonSchemaValidator;
        String instructions;
        final List<McpStatelessServerFeatures.AsyncToolSpecification> tools = new ArrayList<McpStatelessServerFeatures.AsyncToolSpecification>();
        final Map<String, McpStatelessServerFeatures.AsyncResourceSpecification> resources = new HashMap<String, McpStatelessServerFeatures.AsyncResourceSpecification>();
        final Map<String, McpStatelessServerFeatures.AsyncResourceTemplateSpecification> resourceTemplates = new HashMap<String, McpStatelessServerFeatures.AsyncResourceTemplateSpecification>();
        final Map<String, McpStatelessServerFeatures.AsyncPromptSpecification> prompts = new HashMap<String, McpStatelessServerFeatures.AsyncPromptSpecification>();
        final Map<McpSchema.CompleteReference, McpStatelessServerFeatures.AsyncCompletionSpecification> completions = new HashMap<McpSchema.CompleteReference, McpStatelessServerFeatures.AsyncCompletionSpecification>();
        Duration requestTimeout = Duration.ofSeconds(10L);

        public StatelessAsyncSpecification(McpStatelessServerTransport transport) {
            this.transport = transport;
        }

        public StatelessAsyncSpecification uriTemplateManagerFactory(McpUriTemplateManagerFactory uriTemplateManagerFactory) {
            Assert.notNull(uriTemplateManagerFactory, "URI template manager factory must not be null");
            this.uriTemplateManagerFactory = uriTemplateManagerFactory;
            return this;
        }

        public StatelessAsyncSpecification requestTimeout(Duration requestTimeout) {
            Assert.notNull(requestTimeout, "Request timeout must not be null");
            this.requestTimeout = requestTimeout;
            return this;
        }

        public StatelessAsyncSpecification serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public StatelessAsyncSpecification serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public StatelessAsyncSpecification instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public StatelessAsyncSpecification capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public StatelessAsyncSpecification toolCall(McpSchema.Tool tool, BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(callHandler, "Handler must not be null");
            this.assertNoDuplicateTool(tool.name());
            this.tools.add(new McpStatelessServerFeatures.AsyncToolSpecification(tool, callHandler));
            return this;
        }

        public StatelessAsyncSpecification tools(List<McpStatelessServerFeatures.AsyncToolSpecification> toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpStatelessServerFeatures.AsyncToolSpecification tool : toolSpecifications) {
                this.assertNoDuplicateTool(tool.tool().name());
                this.tools.add(tool);
            }
            return this;
        }

        public StatelessAsyncSpecification tools(McpStatelessServerFeatures.AsyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpStatelessServerFeatures.AsyncToolSpecification tool : toolSpecifications) {
                this.assertNoDuplicateTool(tool.tool().name());
                this.tools.add(tool);
            }
            return this;
        }

        private void assertNoDuplicateTool(String toolName) {
            if (this.tools.stream().anyMatch(toolSpec -> toolSpec.tool().name().equals(toolName))) {
                throw new IllegalArgumentException("Tool with name '" + toolName + "' is already registered.");
            }
        }

        public StatelessAsyncSpecification resources(Map<String, McpStatelessServerFeatures.AsyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers map must not be null");
            this.resources.putAll(resourceSpecifications);
            return this;
        }

        public StatelessAsyncSpecification resources(List<McpStatelessServerFeatures.AsyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpStatelessServerFeatures.AsyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public StatelessAsyncSpecification resources(McpStatelessServerFeatures.AsyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpStatelessServerFeatures.AsyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public StatelessAsyncSpecification resourceTemplates(List<McpStatelessServerFeatures.AsyncResourceTemplateSpecification> resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpStatelessServerFeatures.AsyncResourceTemplateSpecification resourceTemplate : resourceTemplates) {
                this.resourceTemplates.put(resourceTemplate.resourceTemplate().uriTemplate(), resourceTemplate);
            }
            return this;
        }

        public StatelessAsyncSpecification resourceTemplates(McpStatelessServerFeatures.AsyncResourceTemplateSpecification ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpStatelessServerFeatures.AsyncResourceTemplateSpecification resourceTemplate : resourceTemplates) {
                this.resourceTemplates.put(resourceTemplate.resourceTemplate().uriTemplate(), resourceTemplate);
            }
            return this;
        }

        public StatelessAsyncSpecification prompts(Map<String, McpStatelessServerFeatures.AsyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts map must not be null");
            this.prompts.putAll(prompts);
            return this;
        }

        public StatelessAsyncSpecification prompts(List<McpStatelessServerFeatures.AsyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpStatelessServerFeatures.AsyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public StatelessAsyncSpecification prompts(McpStatelessServerFeatures.AsyncPromptSpecification ... prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpStatelessServerFeatures.AsyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public StatelessAsyncSpecification completions(List<McpStatelessServerFeatures.AsyncCompletionSpecification> completions) {
            Assert.notNull(completions, "Completions list must not be null");
            for (McpStatelessServerFeatures.AsyncCompletionSpecification completion : completions) {
                this.completions.put(completion.referenceKey(), completion);
            }
            return this;
        }

        public StatelessAsyncSpecification completions(McpStatelessServerFeatures.AsyncCompletionSpecification ... completions) {
            Assert.notNull(completions, "Completions list must not be null");
            for (McpStatelessServerFeatures.AsyncCompletionSpecification completion : completions) {
                this.completions.put(completion.referenceKey(), completion);
            }
            return this;
        }

        public StatelessAsyncSpecification jsonMapper(McpJsonMapper jsonMapper) {
            Assert.notNull(jsonMapper, "JsonMapper must not be null");
            this.jsonMapper = jsonMapper;
            return this;
        }

        public StatelessAsyncSpecification jsonSchemaValidator(JsonSchemaValidator jsonSchemaValidator) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            this.jsonSchemaValidator = jsonSchemaValidator;
            return this;
        }

        public McpStatelessAsyncServer build() {
            McpStatelessServerFeatures.Async features = new McpStatelessServerFeatures.Async(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.completions, this.instructions);
            return new McpStatelessAsyncServer(this.transport, this.jsonMapper == null ? McpJsonMapper.getDefault() : this.jsonMapper, features, this.requestTimeout, this.uriTemplateManagerFactory, this.jsonSchemaValidator != null ? this.jsonSchemaValidator : JsonSchemaValidator.getDefault());
        }
    }

    public static class StatelessSyncSpecification {
        private final McpStatelessServerTransport transport;
        boolean immediateExecution = false;
        McpUriTemplateManagerFactory uriTemplateManagerFactory = new DefaultMcpUriTemplateManagerFactory();
        McpJsonMapper jsonMapper;
        McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        McpSchema.ServerCapabilities serverCapabilities;
        JsonSchemaValidator jsonSchemaValidator;
        String instructions;
        final List<McpStatelessServerFeatures.SyncToolSpecification> tools = new ArrayList<McpStatelessServerFeatures.SyncToolSpecification>();
        final Map<String, McpStatelessServerFeatures.SyncResourceSpecification> resources = new HashMap<String, McpStatelessServerFeatures.SyncResourceSpecification>();
        final Map<String, McpStatelessServerFeatures.SyncResourceTemplateSpecification> resourceTemplates = new HashMap<String, McpStatelessServerFeatures.SyncResourceTemplateSpecification>();
        final Map<String, McpStatelessServerFeatures.SyncPromptSpecification> prompts = new HashMap<String, McpStatelessServerFeatures.SyncPromptSpecification>();
        final Map<McpSchema.CompleteReference, McpStatelessServerFeatures.SyncCompletionSpecification> completions = new HashMap<McpSchema.CompleteReference, McpStatelessServerFeatures.SyncCompletionSpecification>();
        Duration requestTimeout = Duration.ofSeconds(10L);

        public StatelessSyncSpecification(McpStatelessServerTransport transport) {
            this.transport = transport;
        }

        public StatelessSyncSpecification uriTemplateManagerFactory(McpUriTemplateManagerFactory uriTemplateManagerFactory) {
            Assert.notNull(uriTemplateManagerFactory, "URI template manager factory must not be null");
            this.uriTemplateManagerFactory = uriTemplateManagerFactory;
            return this;
        }

        public StatelessSyncSpecification requestTimeout(Duration requestTimeout) {
            Assert.notNull(requestTimeout, "Request timeout must not be null");
            this.requestTimeout = requestTimeout;
            return this;
        }

        public StatelessSyncSpecification serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public StatelessSyncSpecification serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public StatelessSyncSpecification instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public StatelessSyncSpecification capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public StatelessSyncSpecification toolCall(McpSchema.Tool tool, BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(callHandler, "Handler must not be null");
            this.assertNoDuplicateTool(tool.name());
            this.tools.add(new McpStatelessServerFeatures.SyncToolSpecification(tool, callHandler));
            return this;
        }

        public StatelessSyncSpecification tools(List<McpStatelessServerFeatures.SyncToolSpecification> toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpStatelessServerFeatures.SyncToolSpecification tool : toolSpecifications) {
                this.assertNoDuplicateTool(tool.tool().name());
                this.tools.add(tool);
            }
            return this;
        }

        public StatelessSyncSpecification tools(McpStatelessServerFeatures.SyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpStatelessServerFeatures.SyncToolSpecification tool : toolSpecifications) {
                this.assertNoDuplicateTool(tool.tool().name());
                this.tools.add(tool);
            }
            return this;
        }

        private void assertNoDuplicateTool(String toolName) {
            if (this.tools.stream().anyMatch(toolSpec -> toolSpec.tool().name().equals(toolName))) {
                throw new IllegalArgumentException("Tool with name '" + toolName + "' is already registered.");
            }
        }

        public StatelessSyncSpecification resources(Map<String, McpStatelessServerFeatures.SyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers map must not be null");
            this.resources.putAll(resourceSpecifications);
            return this;
        }

        public StatelessSyncSpecification resources(List<McpStatelessServerFeatures.SyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpStatelessServerFeatures.SyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public StatelessSyncSpecification resources(McpStatelessServerFeatures.SyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpStatelessServerFeatures.SyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public StatelessSyncSpecification resourceTemplates(List<McpStatelessServerFeatures.SyncResourceTemplateSpecification> resourceTemplatesSpec) {
            Assert.notNull(resourceTemplatesSpec, "Resource templates must not be null");
            for (McpStatelessServerFeatures.SyncResourceTemplateSpecification resourceTemplate : resourceTemplatesSpec) {
                this.resourceTemplates.put(resourceTemplate.resourceTemplate().uriTemplate(), resourceTemplate);
            }
            return this;
        }

        public StatelessSyncSpecification resourceTemplates(McpStatelessServerFeatures.SyncResourceTemplateSpecification ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpStatelessServerFeatures.SyncResourceTemplateSpecification resourceTemplate : resourceTemplates) {
                this.resourceTemplates.put(resourceTemplate.resourceTemplate().uriTemplate(), resourceTemplate);
            }
            return this;
        }

        public StatelessSyncSpecification prompts(Map<String, McpStatelessServerFeatures.SyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts map must not be null");
            this.prompts.putAll(prompts);
            return this;
        }

        public StatelessSyncSpecification prompts(List<McpStatelessServerFeatures.SyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpStatelessServerFeatures.SyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public StatelessSyncSpecification prompts(McpStatelessServerFeatures.SyncPromptSpecification ... prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpStatelessServerFeatures.SyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public StatelessSyncSpecification completions(List<McpStatelessServerFeatures.SyncCompletionSpecification> completions) {
            Assert.notNull(completions, "Completions list must not be null");
            for (McpStatelessServerFeatures.SyncCompletionSpecification completion : completions) {
                this.completions.put(completion.referenceKey(), completion);
            }
            return this;
        }

        public StatelessSyncSpecification completions(McpStatelessServerFeatures.SyncCompletionSpecification ... completions) {
            Assert.notNull(completions, "Completions list must not be null");
            for (McpStatelessServerFeatures.SyncCompletionSpecification completion : completions) {
                this.completions.put(completion.referenceKey(), completion);
            }
            return this;
        }

        public StatelessSyncSpecification jsonMapper(McpJsonMapper jsonMapper) {
            Assert.notNull(jsonMapper, "JsonMapper must not be null");
            this.jsonMapper = jsonMapper;
            return this;
        }

        public StatelessSyncSpecification jsonSchemaValidator(JsonSchemaValidator jsonSchemaValidator) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            this.jsonSchemaValidator = jsonSchemaValidator;
            return this;
        }

        public StatelessSyncSpecification immediateExecution(boolean immediateExecution) {
            this.immediateExecution = immediateExecution;
            return this;
        }

        public McpStatelessSyncServer build() {
            McpStatelessServerFeatures.Sync syncFeatures = new McpStatelessServerFeatures.Sync(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.completions, this.instructions);
            McpStatelessServerFeatures.Async asyncFeatures = McpStatelessServerFeatures.Async.fromSync(syncFeatures, this.immediateExecution);
            McpStatelessAsyncServer asyncServer = new McpStatelessAsyncServer(this.transport, this.jsonMapper == null ? McpJsonMapper.getDefault() : this.jsonMapper, asyncFeatures, this.requestTimeout, this.uriTemplateManagerFactory, this.jsonSchemaValidator != null ? this.jsonSchemaValidator : JsonSchemaValidator.getDefault());
            return new McpStatelessSyncServer(asyncServer, this.immediateExecution);
        }
    }

    public static abstract class SyncSpecification<S extends SyncSpecification<S>> {
        McpUriTemplateManagerFactory uriTemplateManagerFactory = new DefaultMcpUriTemplateManagerFactory();
        McpJsonMapper jsonMapper;
        McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        McpSchema.ServerCapabilities serverCapabilities;
        String instructions;
        final List<McpServerFeatures.SyncToolSpecification> tools = new ArrayList<McpServerFeatures.SyncToolSpecification>();
        final Map<String, McpServerFeatures.SyncResourceSpecification> resources = new HashMap<String, McpServerFeatures.SyncResourceSpecification>();
        final Map<String, McpServerFeatures.SyncResourceTemplateSpecification> resourceTemplates = new HashMap<String, McpServerFeatures.SyncResourceTemplateSpecification>();
        JsonSchemaValidator jsonSchemaValidator;
        final Map<String, McpServerFeatures.SyncPromptSpecification> prompts = new HashMap<String, McpServerFeatures.SyncPromptSpecification>();
        final Map<McpSchema.CompleteReference, McpServerFeatures.SyncCompletionSpecification> completions = new HashMap<McpSchema.CompleteReference, McpServerFeatures.SyncCompletionSpecification>();
        final List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeHandlers = new ArrayList<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>>();
        Duration requestTimeout = Duration.ofSeconds(10L);
        boolean immediateExecution = false;

        public abstract McpSyncServer build();

        public SyncSpecification<S> uriTemplateManagerFactory(McpUriTemplateManagerFactory uriTemplateManagerFactory) {
            Assert.notNull(uriTemplateManagerFactory, "URI template manager factory must not be null");
            this.uriTemplateManagerFactory = uriTemplateManagerFactory;
            return this;
        }

        public SyncSpecification<S> requestTimeout(Duration requestTimeout) {
            Assert.notNull(requestTimeout, "Request timeout must not be null");
            this.requestTimeout = requestTimeout;
            return this;
        }

        public SyncSpecification<S> serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public SyncSpecification<S> serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public SyncSpecification<S> instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public SyncSpecification<S> capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        @Deprecated
        public SyncSpecification<S> tool(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.assertNoDuplicateTool(tool.name());
            this.tools.add(new McpServerFeatures.SyncToolSpecification(tool, handler));
            return this;
        }

        public SyncSpecification<S> toolCall(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, McpSchema.CallToolRequest, McpSchema.CallToolResult> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.assertNoDuplicateTool(tool.name());
            this.tools.add(new McpServerFeatures.SyncToolSpecification(tool, null, handler));
            return this;
        }

        public SyncSpecification<S> tools(List<McpServerFeatures.SyncToolSpecification> toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpServerFeatures.SyncToolSpecification tool : toolSpecifications) {
                String toolName = tool.tool().name();
                this.assertNoDuplicateTool(toolName);
                this.tools.add(tool);
            }
            return this;
        }

        public SyncSpecification<S> tools(McpServerFeatures.SyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpServerFeatures.SyncToolSpecification tool : toolSpecifications) {
                this.assertNoDuplicateTool(tool.tool().name());
                this.tools.add(tool);
            }
            return this;
        }

        private void assertNoDuplicateTool(String toolName) {
            if (this.tools.stream().anyMatch(toolSpec -> toolSpec.tool().name().equals(toolName))) {
                throw new IllegalArgumentException("Tool with name '" + toolName + "' is already registered.");
            }
        }

        public SyncSpecification<S> resources(Map<String, McpServerFeatures.SyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers map must not be null");
            this.resources.putAll(resourceSpecifications);
            return this;
        }

        public SyncSpecification<S> resources(List<McpServerFeatures.SyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public SyncSpecification<S> resources(McpServerFeatures.SyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public SyncSpecification<S> resourceTemplates(List<McpServerFeatures.SyncResourceTemplateSpecification> resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpServerFeatures.SyncResourceTemplateSpecification resource : resourceTemplates) {
                this.resourceTemplates.put(resource.resourceTemplate().uriTemplate(), resource);
            }
            return this;
        }

        public SyncSpecification<S> resourceTemplates(McpServerFeatures.SyncResourceTemplateSpecification ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpServerFeatures.SyncResourceTemplateSpecification resourceTemplate : resourceTemplates) {
                this.resourceTemplates.put(resourceTemplate.resourceTemplate().uriTemplate(), resourceTemplate);
            }
            return this;
        }

        public SyncSpecification<S> prompts(Map<String, McpServerFeatures.SyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts map must not be null");
            this.prompts.putAll(prompts);
            return this;
        }

        public SyncSpecification<S> prompts(List<McpServerFeatures.SyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.SyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public SyncSpecification<S> prompts(McpServerFeatures.SyncPromptSpecification ... prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.SyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public SyncSpecification<S> completions(List<McpServerFeatures.SyncCompletionSpecification> completions) {
            Assert.notNull(completions, "Completions list must not be null");
            for (McpServerFeatures.SyncCompletionSpecification completion : completions) {
                this.completions.put(completion.referenceKey(), completion);
            }
            return this;
        }

        public SyncSpecification<S> completions(McpServerFeatures.SyncCompletionSpecification ... completions) {
            Assert.notNull(completions, "Completions list must not be null");
            for (McpServerFeatures.SyncCompletionSpecification completion : completions) {
                this.completions.put(completion.referenceKey(), completion);
            }
            return this;
        }

        public SyncSpecification<S> rootsChangeHandler(BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> handler) {
            Assert.notNull(handler, "Consumer must not be null");
            this.rootsChangeHandlers.add(handler);
            return this;
        }

        public SyncSpecification<S> rootsChangeHandlers(List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            this.rootsChangeHandlers.addAll(handlers);
            return this;
        }

        public SyncSpecification<S> rootsChangeHandlers(BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> ... handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            return this.rootsChangeHandlers(List.of(handlers));
        }

        public SyncSpecification<S> jsonMapper(McpJsonMapper jsonMapper) {
            Assert.notNull(jsonMapper, "JsonMapper must not be null");
            this.jsonMapper = jsonMapper;
            return this;
        }

        public SyncSpecification<S> jsonSchemaValidator(JsonSchemaValidator jsonSchemaValidator) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            this.jsonSchemaValidator = jsonSchemaValidator;
            return this;
        }

        public SyncSpecification<S> immediateExecution(boolean immediateExecution) {
            this.immediateExecution = immediateExecution;
            return this;
        }
    }

    public static abstract class AsyncSpecification<S extends AsyncSpecification<S>> {
        McpUriTemplateManagerFactory uriTemplateManagerFactory = new DefaultMcpUriTemplateManagerFactory();
        McpJsonMapper jsonMapper;
        McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        McpSchema.ServerCapabilities serverCapabilities;
        JsonSchemaValidator jsonSchemaValidator;
        String instructions;
        final List<McpServerFeatures.AsyncToolSpecification> tools = new ArrayList<McpServerFeatures.AsyncToolSpecification>();
        final Map<String, McpServerFeatures.AsyncResourceSpecification> resources = new HashMap<String, McpServerFeatures.AsyncResourceSpecification>();
        final Map<String, McpServerFeatures.AsyncResourceTemplateSpecification> resourceTemplates = new HashMap<String, McpServerFeatures.AsyncResourceTemplateSpecification>();
        final Map<String, McpServerFeatures.AsyncPromptSpecification> prompts = new HashMap<String, McpServerFeatures.AsyncPromptSpecification>();
        final Map<McpSchema.CompleteReference, McpServerFeatures.AsyncCompletionSpecification> completions = new HashMap<McpSchema.CompleteReference, McpServerFeatures.AsyncCompletionSpecification>();
        final List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeHandlers = new ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>>();
        Duration requestTimeout = Duration.ofHours(10L);

        public abstract McpAsyncServer build();

        public AsyncSpecification<S> uriTemplateManagerFactory(McpUriTemplateManagerFactory uriTemplateManagerFactory) {
            Assert.notNull(uriTemplateManagerFactory, "URI template manager factory must not be null");
            this.uriTemplateManagerFactory = uriTemplateManagerFactory;
            return this;
        }

        public AsyncSpecification<S> requestTimeout(Duration requestTimeout) {
            Assert.notNull(requestTimeout, "Request timeout must not be null");
            this.requestTimeout = requestTimeout;
            return this;
        }

        public AsyncSpecification<S> serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public AsyncSpecification<S> serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public AsyncSpecification<S> instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public AsyncSpecification<S> capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        @Deprecated
        public AsyncSpecification<S> tool(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.assertNoDuplicateTool(tool.name());
            this.tools.add(new McpServerFeatures.AsyncToolSpecification(tool, handler));
            return this;
        }

        public AsyncSpecification<S> toolCall(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(callHandler, "Handler must not be null");
            this.assertNoDuplicateTool(tool.name());
            this.tools.add(McpServerFeatures.AsyncToolSpecification.builder().tool(tool).callHandler(callHandler).build());
            return this;
        }

        public AsyncSpecification<S> tools(List<McpServerFeatures.AsyncToolSpecification> toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpServerFeatures.AsyncToolSpecification tool : toolSpecifications) {
                this.assertNoDuplicateTool(tool.tool().name());
                this.tools.add(tool);
            }
            return this;
        }

        public AsyncSpecification<S> tools(McpServerFeatures.AsyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpServerFeatures.AsyncToolSpecification tool : toolSpecifications) {
                this.assertNoDuplicateTool(tool.tool().name());
                this.tools.add(tool);
            }
            return this;
        }

        private void assertNoDuplicateTool(String toolName) {
            if (this.tools.stream().anyMatch(toolSpec -> toolSpec.tool().name().equals(toolName))) {
                throw new IllegalArgumentException("Tool with name '" + toolName + "' is already registered.");
            }
        }

        public AsyncSpecification<S> resources(Map<String, McpServerFeatures.AsyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers map must not be null");
            this.resources.putAll(resourceSpecifications);
            return this;
        }

        public AsyncSpecification<S> resources(List<McpServerFeatures.AsyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public AsyncSpecification<S> resources(McpServerFeatures.AsyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public AsyncSpecification<S> resourceTemplates(List<McpServerFeatures.AsyncResourceTemplateSpecification> resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpServerFeatures.AsyncResourceTemplateSpecification resourceTemplate : resourceTemplates) {
                this.resourceTemplates.put(resourceTemplate.resourceTemplate().uriTemplate(), resourceTemplate);
            }
            return this;
        }

        public AsyncSpecification<S> resourceTemplates(McpServerFeatures.AsyncResourceTemplateSpecification ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpServerFeatures.AsyncResourceTemplateSpecification resource : resourceTemplates) {
                this.resourceTemplates.put(resource.resourceTemplate().uriTemplate(), resource);
            }
            return this;
        }

        public AsyncSpecification<S> prompts(Map<String, McpServerFeatures.AsyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts map must not be null");
            this.prompts.putAll(prompts);
            return this;
        }

        public AsyncSpecification<S> prompts(List<McpServerFeatures.AsyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.AsyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public AsyncSpecification<S> prompts(McpServerFeatures.AsyncPromptSpecification ... prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.AsyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public AsyncSpecification<S> completions(List<McpServerFeatures.AsyncCompletionSpecification> completions) {
            Assert.notNull(completions, "Completions list must not be null");
            for (McpServerFeatures.AsyncCompletionSpecification completion : completions) {
                this.completions.put(completion.referenceKey(), completion);
            }
            return this;
        }

        public AsyncSpecification<S> completions(McpServerFeatures.AsyncCompletionSpecification ... completions) {
            Assert.notNull(completions, "Completions list must not be null");
            for (McpServerFeatures.AsyncCompletionSpecification completion : completions) {
                this.completions.put(completion.referenceKey(), completion);
            }
            return this;
        }

        public AsyncSpecification<S> rootsChangeHandler(BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>> handler) {
            Assert.notNull(handler, "Consumer must not be null");
            this.rootsChangeHandlers.add(handler);
            return this;
        }

        public AsyncSpecification<S> rootsChangeHandlers(List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            this.rootsChangeHandlers.addAll(handlers);
            return this;
        }

        public AsyncSpecification<S> rootsChangeHandlers(BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>> ... handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            return this.rootsChangeHandlers(Arrays.asList(handlers));
        }

        public AsyncSpecification<S> jsonMapper(McpJsonMapper jsonMapper) {
            Assert.notNull(jsonMapper, "JsonMapper must not be null");
            this.jsonMapper = jsonMapper;
            return this;
        }

        public AsyncSpecification<S> jsonSchemaValidator(JsonSchemaValidator jsonSchemaValidator) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            this.jsonSchemaValidator = jsonSchemaValidator;
            return this;
        }
    }
}

