/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.trust.TrustedCodeService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.bokeh.BokehWebAppMeta;
import com.dataiku.dip.webapps.dash.DashWebAppMeta;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/webapps"})
public class PublicAPIWebAppsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    TrustedCodeService trustedCodeService;

    @AuditedCall(value={"msgType", "webapps-get", "projectKey", "${projectKey}", "webappId", "${webappId}"})
    @RequestMapping(value={"/{webappId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String webappId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            WebApp webapp = this.webAppsService.getOrNullUnsafe(projectKey, webappId);
            if (webapp == null) {
                throw new IllegalArgumentException("Webapp '" + webappId + "' in '" + projectKey + "' doesn't exist");
            }
            PublicAPIWebAppsController.writeJSON((HttpServletResponse)resp, (Object)webapp);
        }
    }

    @AuditedCall(value={"msgType", "webapps-trust", "projectKey", "${projectKey}", "webappId", "${webappId}", "trustForEverybody", "${trustForEverybody}"})
    @RequestMapping(value={"/{webappId}/actions/trust"}, method={RequestMethod.POST})
    @ResponseBody
    public TrustedCodeService.TrustedCodeCheckReport trustWebapp(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String webappId, @RequestParam(defaultValue="false") boolean trustForEverybody) throws Exception {
        String precomputedFingerprint;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            precomputedFingerprint = this.trustedCodeService.precomputeFingerprintIfPossiblyNeeded_T(authCtx, projectKey, webappId);
        }
        this.trustedCodeService.checkCanTrust_NT(authCtx, projectKey, webappId, trustForEverybody, precomputedFingerprint);
        return this.trustedCodeService.trustWebApp_NT(authCtx, projectKey, webappId, trustForEverybody, precomputedFingerprint);
    }

    @AuditedCall(value={"msgType", "webapps-list-heads", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<WebApp.WebAppListItem> listHeads(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.webAppsService.listHeads_NT(projectKey);
    }

    @AuditedCall(value={"msgType", "webapps-update", "projectKey", "${projectKey}", "webappId", "${webappId}"})
    @RequestMapping(value={"/{webappId}"}, method={RequestMethod.PUT})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String webappId) throws Exception {
        String precomputedFingerprint;
        WebAppsService.WebAppSaveResponse ret;
        AuthCtx authCtx;
        WebApp webApp = (WebApp)this.getRequestBodyAs(req, WebApp.class);
        if (!Objects.equals(webApp.id, webappId)) {
            throw new IllegalArgumentException("Webapp ID does not match \"id\" property");
        }
        if (!Objects.equals(webApp.projectKey, projectKey)) {
            throw new IllegalArgumentException("Webapp ID does not match \"projectKey\" property");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            WebAppMeta meta = WebAppRegistry.getMeta((String)webApp.type);
            if (!meta.isCustomWebApp()) {
                this.licenseEnforcementService.checkWebappsAllowed(authCtx);
            }
            if (meta == ShinyWebAppMeta.META) {
                authCtx.failIfNoSafeCode("Write R code");
            } else if (meta == BokehWebAppMeta.META || meta == DashWebAppMeta.META || webApp.params.isBackendEnabled()) {
                authCtx.failIfNoSafeCode("Write Python code");
            }
            ret = this.webAppsService.save(webApp, false);
            WebAppHandler wah = WebAppHandler.buildHandler((WebApp)webApp);
            wah.writeCodeFiles();
            precomputedFingerprint = this.trustedCodeService.precomputeFingerprintIfPossiblyNeeded_T(authCtx, projectKey, webappId);
            t.commitV("Update web app %s (%s.%s)", new Object[]{webApp.name, webApp.projectKey, webApp.id});
        }
        this.trustedCodeService.autoTrustIfNeededWebApp_NT(authCtx, webApp.projectKey, webApp.id, precomputedFingerprint);
        PublicAPIWebAppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "webapp-backend-stop", "projectKey", "${projectKey}", "webappId", "${webappId}"})
    @RequestMapping(value={"/{webappId}/backend/actions/stop"}, method={RequestMethod.PUT})
    public void stopBackend(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String webappId) throws Exception {
        WebApp webApp;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            webApp = this.webAppsService.getMandatoryUnsafe_noCode(projectKey, webappId);
        }
        this.webAppsService.stopBackend(webApp);
    }

    @AuditedCall(value={"msgType", "webapp-backend-restart", "projectKey", "${projectKey}", "webappId", "${webappId}"})
    @RequestMapping(value={"/{webappId}/backend/actions/restart"}, method={RequestMethod.PUT})
    public void restartBackend(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String webappId) throws Exception {
        WebApp webApp;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            webApp = this.webAppsService.getMandatoryUnsafe(projectKey, webappId);
        }
        FutureResponse ret = this.webAppsService.restartBackend_NT(authCtx, webApp);
        PublicAPIWebAppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "webapp-backend", "projectKey", "${projectKey}", "webappId", "${webappId}"})
    @RequestMapping(value={"/{webappId}/backend/state"}, method={RequestMethod.GET})
    public void backendState(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String webappId) throws Exception {
        WebApp webApp;
        boolean keepFutureIdInResponse = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            webApp = this.webAppsService.getMandatoryUnsafe(projectKey, webappId);
        }
        WebAppBackendInstance.BackendState state = this.webAppsService.getBackendState(webApp, keepFutureIdInResponse);
        PublicAPIWebAppsController.writeJSON((HttpServletResponse)resp, (Object)state);
    }
}

