/*
 * Decompiled with CFR 0.152.
 */
package com.neilalexander.jnacl.crypto;

import com.neilalexander.jnacl.crypto.verify_16;

public class poly1305 {
    final int CRYPTO_BYTES = 16;
    final int CRYPTO_KEYBYTES = 32;
    static final int[] minusp = new int[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252};

    public static int crypto_onetimeauth_verify(byte[] h2, int hoffset, byte[] inv, int invoffset, long inlen, byte[] k) {
        byte[] correct = new byte[16];
        poly1305.crypto_onetimeauth(correct, 0, inv, invoffset, inlen, k);
        return verify_16.crypto_verify(h2, hoffset, correct);
    }

    static void add(int[] h2, int[] c) {
        int u = 0;
        for (int j = 0; j < 17; ++j) {
            h2[j] = (u += h2[j] + c[j]) & 0xFF;
            u >>>= 8;
        }
    }

    static void squeeze(int[] h2) {
        int j;
        int u = 0;
        for (j = 0; j < 16; ++j) {
            h2[j] = (u += h2[j]) & 0xFF;
            u >>>= 8;
        }
        h2[16] = (u += h2[16]) & 3;
        u = 5 * (u >>> 2);
        for (j = 0; j < 16; ++j) {
            h2[j] = (u += h2[j]) & 0xFF;
            u >>>= 8;
        }
        h2[16] = u += h2[16];
    }

    static void freeze(int[] h2) {
        int[] horig = new int[17];
        for (int j = 0; j < 17; ++j) {
            horig[j] = h2[j];
        }
        poly1305.add(h2, minusp);
        int negative = -(h2[16] >>> 7);
        for (int j = 0; j < 17; ++j) {
            int n = j;
            h2[n] = h2[n] ^ negative & (horig[j] ^ h2[j]);
        }
    }

    static void mulmod(int[] h2, int[] r) {
        int i;
        int[] hr = new int[17];
        for (i = 0; i < 17; ++i) {
            int j;
            int u = 0;
            for (j = 0; j <= i; ++j) {
                u += h2[j] * r[i - j];
            }
            for (j = i + 1; j < 17; ++j) {
                u += 320 * h2[j] * r[i + 17 - j];
            }
            hr[i] = u;
        }
        for (i = 0; i < 17; ++i) {
            h2[i] = hr[i];
        }
        poly1305.squeeze(h2);
    }

    public static int crypto_onetimeauth(byte[] outv, int outvoffset, byte[] inv, int invoffset, long inlen, byte[] k) {
        int j;
        int[] r = new int[17];
        int[] h2 = new int[17];
        int[] c = new int[17];
        r[0] = k[0] & 0xFF;
        r[1] = k[1] & 0xFF;
        r[2] = k[2] & 0xFF;
        r[3] = k[3] & 0xF;
        r[4] = k[4] & 0xFC;
        r[5] = k[5] & 0xFF;
        r[6] = k[6] & 0xFF;
        r[7] = k[7] & 0xF;
        r[8] = k[8] & 0xFC;
        r[9] = k[9] & 0xFF;
        r[10] = k[10] & 0xFF;
        r[11] = k[11] & 0xF;
        r[12] = k[12] & 0xFC;
        r[13] = k[13] & 0xFF;
        r[14] = k[14] & 0xFF;
        r[15] = k[15] & 0xF;
        r[16] = 0;
        for (j = 0; j < 17; ++j) {
            h2[j] = 0;
        }
        while (inlen > 0L) {
            for (j = 0; j < 17; ++j) {
                c[j] = 0;
            }
            for (j = 0; j < 16 && (long)j < inlen; ++j) {
                c[j] = inv[invoffset + j] & 0xFF;
            }
            c[j] = 1;
            invoffset += j;
            inlen -= (long)j;
            poly1305.add(h2, c);
            poly1305.mulmod(h2, r);
        }
        poly1305.freeze(h2);
        for (j = 0; j < 16; ++j) {
            c[j] = k[j + 16] & 0xFF;
        }
        c[16] = 0;
        poly1305.add(h2, c);
        for (j = 0; j < 16; ++j) {
            outv[j + outvoffset] = (byte)h2[j];
        }
        return 0;
    }
}

