/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Result;
import java.util.HashMap;
import java.util.Map;

public class ClassificationResult
extends Result<String> {
    private final double[] probabilities;
    private final String partition;

    public Map<String, Double> remapProbabilities(String[] classes) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        if (this.probabilities == null) {
            for (String clazz : classes) {
                res.put(clazz, null);
            }
        } else {
            if (classes.length != this.probabilities.length) {
                throw new IllegalArgumentException("Size mismatch between classes(" + classes.length + ") and probabilities(" + this.probabilities.length);
            }
            for (int i = 0; i < classes.length; ++i) {
                res.put(classes[i], this.probabilities[i]);
            }
        }
        return res;
    }

    public ClassificationResult(String prediction, double[] probabilities, String partition) {
        super(prediction);
        this.probabilities = probabilities;
        this.partition = partition;
    }

    public static ClassificationResult empty(String partition) {
        return new ClassificationResult(null, null, partition);
    }

    public double[] getProbabilities() {
        return this.probabilities;
    }

    public String getPartition() {
        return this.partition;
    }

    public static class RawResult
    extends Result.RawResult {
        public final Map<String, Double> probabilities;

        public RawResult(ClassificationResult result, String[] classes) {
            super(result);
            this.probabilities = result.remapProbabilities(classes);
        }
    }
}

