/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;

public class GsonTypeAdapterUtils {
    public static boolean nextTokenIsNotNull(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return false;
        }
        return true;
    }

    public static String nullSafeNextString(JsonReader reader) throws IOException {
        if (GsonTypeAdapterUtils.nextTokenIsNotNull(reader)) {
            return reader.nextString();
        }
        return null;
    }

    public static Long nullSafeNextLong(JsonReader reader) throws IOException {
        if (GsonTypeAdapterUtils.nextTokenIsNotNull(reader)) {
            return reader.nextLong();
        }
        return null;
    }

    public static Integer nullSafeNextInt(JsonReader reader) throws IOException {
        if (GsonTypeAdapterUtils.nextTokenIsNotNull(reader)) {
            return reader.nextInt();
        }
        return null;
    }

    public static Double nullSafeNextDouble(JsonReader reader) throws IOException {
        if (GsonTypeAdapterUtils.nextTokenIsNotNull(reader)) {
            return reader.nextDouble();
        }
        return null;
    }

    public static Float nullSafeNextFloat(JsonReader reader) throws IOException {
        if (GsonTypeAdapterUtils.nextTokenIsNotNull(reader)) {
            return Float.valueOf((float)reader.nextDouble());
        }
        return null;
    }

    public static Boolean nullSafeNextBoolean(JsonReader reader) throws IOException {
        if (GsonTypeAdapterUtils.nextTokenIsNotNull(reader)) {
            return reader.nextBoolean();
        }
        return null;
    }
}

