/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.model.hive;

import com.dataiku.hproxy.model.hive.ColumnSchema;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ValidationResult {
    public boolean ok = false;
    public List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
    public List<InsertOverwriteDef> insertOverwrites = new ArrayList<InsertOverwriteDef>();
    public List<String> plan = new ArrayList<String>();

    public static ValidationResult makeValidationTimeoutResult() {
        ValidationMessage timeoutMessage = new ValidationMessage();
        timeoutMessage.errorMessage = "Hive query validation timed out";
        ValidationResult timeoutResponse = new ValidationResult();
        timeoutResponse.messages.add(timeoutMessage);
        return timeoutResponse;
    }

    public static class ValidationMessage {
        public Severity severity = Severity.ERROR;
        public int errorLineFrom = 0;
        public int errorLineTo = 1000000;
        public int column = -1;
        public String errorMessage = "";

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ValidationMessage)) {
                return false;
            }
            ValidationMessage vm = (ValidationMessage)obj;
            return this.severity == vm.severity && this.errorLineFrom == vm.errorLineFrom && this.errorLineTo == vm.errorLineTo && this.column == vm.column && StringUtils.equals((String)this.errorMessage, (String)vm.errorMessage);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.severity).append(this.errorLineFrom).append(this.errorLineTo).append(this.column).append((Object)this.errorMessage).toHashCode();
        }

        public static enum Severity {
            ERROR,
            WARNING;

        }
    }

    public static class InsertOverwriteDef {
        public String destinationTable;
        public List<ColumnSchema> schema = new ArrayList<ColumnSchema>();
        public int lineFrom;
        public int lineTo;
    }
}

