/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.classpathfix.DKUInts;
import com.dataiku.dip.shaker.processors.time.ical.HolidayOccurrence;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysFinder;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WeekendDatabase
implements HolidaysFinder {
    private final Map<String, WeekendDesc> handlers = new HashMap<String, WeekendDesc>();
    private final HashMap<String, DateTimeZone> timezones = new HashMap();

    private WeekendDatabase() {
    }

    public static WeekendDatabase empty() {
        return new WeekendDatabase();
    }

    public static WeekendDatabase loadFromFile(File file) throws IOException {
        WeekendDatabase db = new WeekendDatabase();
        Interner stringInterner = Interners.newStrongInterner();
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isBlank((String)line)) {
                    break;
                }
                if (line.startsWith("#")) continue;
                String[] splitted = line.split("\\|");
                if (splitted.length != 3) {
                    throw new IOException("Invalid record:" + line);
                }
                String calendarId = (String)stringInterner.intern((Object)splitted[0]);
                String preferredTimezone = (String)stringInterner.intern((Object)splitted[1]);
                String[] weekendDays = StringUtils.split((String)splitted[2], (String)",");
                int[] days = new int[weekendDays.length];
                for (int i = 0; i < weekendDays.length; ++i) {
                    days[i] = Days.valueOf(weekendDays[i]).getNumber();
                }
                WeekendDesc wh = new WeekendDesc();
                wh.weekendDays = days;
                wh.preferredTimezone = preferredTimezone;
                wh.calendarId = calendarId;
                db.handlers.put(calendarId, wh);
                if (StringUtils.isBlank((String)wh.preferredTimezone)) continue;
                DateTimeZone tz = DateTimeZone.forID((String)wh.preferredTimezone);
                db.timezones.put(wh.preferredTimezone, tz);
            }
        }
        return db;
    }

    @Override
    public List<HolidayOccurrence> searchForDay(int year, int month, int day, String selectedCalendar) {
        LocalDate dt;
        int dow;
        WeekendDesc wd = this.handlers.get(selectedCalendar);
        if (wd == null) {
            wd = this.handlers.get("");
        }
        if (wd != null && DKUInts.contains((int[])wd.weekendDays, (int)(dow = (dt = LocalDate.of(year, month, day)).getDayOfWeek().getValue()))) {
            ArrayList<HolidayOccurrence> occurrences = new ArrayList<HolidayOccurrence>(1);
            HolidayOccurrence occurrence = new HolidayOccurrence("Weekend", wd.calendarId, 0, 0, wd.preferredTimezone, HolidayOccurrence.Type.WEEKEND, "");
            occurrences.add(occurrence);
            return occurrences;
        }
        return Collections.emptyList();
    }

    @Override
    public List<HolidayOccurrence> searchForDay(DateTime date, String selectedCalendar) {
        WeekendDesc wd = this.handlers.get(selectedCalendar);
        if (wd == null) {
            wd = this.handlers.get("");
        }
        if (wd != null && !StringUtils.isBlank((String)wd.preferredTimezone)) {
            DateTimeZone dtz = this.timezones.get(wd.preferredTimezone);
            DateTime timezoned = date.withZone(dtz);
            return this.searchForDay(timezoned.getYear(), timezoned.getMonthOfYear(), timezoned.getDayOfMonth(), selectedCalendar);
        }
        return Collections.emptyList();
    }

    public List<HolidayOccurrence> searchForPeriod(DateTime start, int numberOfDays, String selectedCalendar) {
        WeekendDesc wd = this.handlers.get(selectedCalendar);
        if (wd == null) {
            wd = this.handlers.get("");
        }
        if (wd != null && !StringUtils.isBlank((String)wd.preferredTimezone)) {
            DateTimeZone dtz = this.timezones.get(wd.preferredTimezone);
            DateTime startZoned = start.withZone(dtz);
            return this.searchForPeriod(startZoned.getYear(), startZoned.getMonthOfYear(), startZoned.getDayOfMonth(), numberOfDays, selectedCalendar);
        }
        return Collections.emptyList();
    }

    public List<HolidayOccurrence> searchForPeriod(int startYear, int startMonth, int startDay, int numberOfDays, String selectedCalendar) {
        WeekendDesc wd = this.handlers.get(selectedCalendar);
        if (wd == null) {
            wd = this.handlers.get("");
        }
        if (wd != null) {
            LocalDate date = LocalDate.of(startYear, startMonth, startDay);
            ArrayList<HolidayOccurrence> occurrences = new ArrayList<HolidayOccurrence>(1);
            for (int i = 0; i < numberOfDays; ++i) {
                int dow = date.getDayOfWeek().getValue();
                if (DKUInts.contains((int[])wd.weekendDays, (int)dow)) {
                    HolidayOccurrence occurrence = new HolidayOccurrence("Weekend", wd.calendarId, HolidayOccurrence.packDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth()), 0, wd.preferredTimezone, HolidayOccurrence.Type.WEEKEND, "");
                    occurrences.add(occurrence);
                }
                date = date.plusDays(1L);
            }
            return occurrences;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listAvailableCalendars() {
        ArrayList<String> out = new ArrayList<String>();
        for (String k : this.handlers.keySet()) {
            if (StringUtils.isBlank((String)k)) continue;
            out.add(k);
        }
        return out;
    }

    public static enum Days {
        MONDAY(1),
        TUESDAY(2),
        WEDNESDAY(3),
        THURSDAY(4),
        FRIDAY(5),
        SATURDAY(6),
        SUNDAY(7);

        private int number;

        private Days(int number) {
            this.number = number;
        }

        int getNumber() {
            return this.number;
        }
    }

    private static class WeekendDesc {
        int[] weekendDays;
        String calendarId;
        String preferredTimezone;

        private WeekendDesc() {
        }
    }
}

