/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.utils.SafePatternMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class UserAgentClassifierAlgorithm {
    List<SimpleMatcher> beginMatches = new ArrayList<SimpleMatcher>();
    List<PatternBrowserWithVersionMatcher> browserMatchers = new ArrayList<PatternBrowserWithVersionMatcher>();
    List<SimpleMatcher> endMatches = new ArrayList<SimpleMatcher>();
    SafePatternMatcher firefox;
    SafePatternMatcher firefoxOldVersions;
    SafePatternMatcher ie;
    SafePatternMatcher ie11;
    SafePatternMatcher iosVersioniPhone;
    SafePatternMatcher iosVersioniPad;
    SafePatternMatcher androidVersionMatcher;
    SafePatternMatcher winPhoneVersionMatcher;
    SafePatternMatcher macOSXVersionMatcher;
    SafePatternMatcher windowsVersionMatcher;
    SafePatternMatcher windowsBitsMatcher;

    public UserAgentClassifierAlgorithm() {
        this.initClassifier();
    }

    public void detect(String v, UserAgentMatch match) {
        String version;
        String ffVersion;
        String ieVersion;
        if (v.length() == 0 || v.equals("-")) {
            match.type = "none";
            return;
        }
        v = v.toLowerCase();
        for (SimpleMatcher sm : this.beginMatches) {
            if (!sm.matches(v)) continue;
            match.type = sm.type;
            match.category = sm.type;
            match.brand = sm.brand;
            return;
        }
        if (v.contains("msie") && (ieVersion = this.ie.matchesAndGetFirst(v)) != null) {
            if (ieVersion.equals("10.0")) {
                match.category = "IE 10";
            }
            if (ieVersion.equals("9.0")) {
                match.category = "IE 9";
            }
            if (ieVersion.equals("8.0")) {
                match.category = "IE 8";
            }
            if (ieVersion.startsWith("7.0")) {
                match.category = "IE 7";
            }
            if (ieVersion.startsWith("6.")) {
                match.category = "IE 6";
            }
            match.brand = "IE";
            match.version = ieVersion;
            match.type = "browser";
            this.detectOS(v, match);
            return;
        }
        if (v.contains("trident") && (ieVersion = this.ie11.matchesAndGetFirst(v)) != null) {
            match.brand = "IE";
            match.category = "IE 11";
            match.version = ieVersion;
            match.type = "browser";
            this.detectOS(v, match);
            return;
        }
        if (v.contains("firefox") && (ffVersion = this.firefox.matchesAndGetFirst(v)) != null) {
            match.type = "browser";
            match.brand = "Firefox";
            match.version = ffVersion;
            match.category = this.firefoxOldVersions.matches(ffVersion) ? "Firefox (<=3.6)" : "Firefox (>=4)";
            this.detectOS(v, match);
            return;
        }
        if (v.contains("cpu iphone") && v.contains("applewebkit")) {
            match.type = "phone";
            match.brand = "Mobile Safari";
            match.category = v.contains(" Twitter") ? "Twitter" : (v.contains(" focus/") ? "Firefox Focus" : (v.contains(" crios/") ? "Mobile Chrome" : (v.contains(" gsa/") ? "Google Search App" : "Mobile Safari")));
            match.os = "iOS";
            match.osFlavor = "iPhone";
            version = this.iosVersioniPhone.findAndGetFirst(v);
            if (version != null) {
                match.version = match.osVersion = version.replace('_', '.');
            }
            return;
        }
        if ((v.contains("ipad; u; cpu") || v.contains("ipad; cpu")) && v.contains("applewebkit")) {
            match.type = "tablet";
            match.category = "Mobile Safari";
            match.brand = "Mobile Safari";
            match.os = "iOS";
            match.osFlavor = "iPad";
            match.version = match.osVersion = this.iosVersioniPad.findAndGetFirst(v);
            return;
        }
        if (v.contains("android")) {
            String string = match.type = v.contains("mobile") ? "phone" : "tablet";
            if (v.contains(" Twitter")) {
                match.brand = "Android";
                match.category = "Twitter";
            } else if (v.contains("opera/")) {
                match.brand = "Opera";
                match.category = "Mobile Opera";
            } else if (v.contains("chrome/")) {
                match.brand = "Chrome";
                match.category = "Mobile Chrome";
            } else {
                match.brand = "Android Browser";
                match.category = "Android Browser";
            }
            match.os = "Android";
            match.version = match.osVersion = this.androidVersionMatcher.findAndGetFirst(v);
            return;
        }
        if (v.contains("windows phone")) {
            match.type = "phone";
            match.brand = "Windows Phone";
            match.category = "Windows Phone";
            match.os = "Windows Phone";
            version = this.winPhoneVersionMatcher.findAndGetFirst(v);
            if (version != null) {
                match.version = match.osVersion = version.replace('_', '.');
            }
            return;
        }
        for (PatternBrowserWithVersionMatcher pm : this.browserMatchers) {
            if (!pm.matchAndFill(v, match)) continue;
            return;
        }
        for (SimpleMatcher sm : this.endMatches) {
            if (!sm.matches(v)) continue;
            match.type = sm.type;
            match.category = sm.type;
            match.brand = sm.brand;
            return;
        }
        match.type = "unknown";
    }

    private void detectOS(String v, UserAgentMatch match) {
        if (v.contains("ipad") || v.contains("iphone") || v.contains("ipod")) {
            match.os = "iOS";
            match.osFlavor = v.contains("iPod") ? "iPod" : (v.contains("iPad") ? "iPad" : "iPhone");
        } else if (v.contains("mac os x")) {
            match.os = "MacOS X";
            String version = this.macOSXVersionMatcher.findAndGetFirst(v);
            if (version != null) {
                match.osVersion = version.replace('_', '.');
            }
        } else if (v.contains("windows")) {
            match.os = "Windows";
            String version = this.windowsVersionMatcher.findAndGetFirst(v);
            if (version != null) {
                String v64 = this.windowsBitsMatcher.findAndGetFirst(v);
                boolean found64 = "64".equals(v64);
                match.osFlavor = found64 ? "64 bits" : "32 bits";
                match.osVersion = "Windows ";
                switch (version) {
                    case "6.3": {
                        match.osVersion = match.osVersion + "8.1";
                        break;
                    }
                    case "6.2": {
                        match.osVersion = match.osVersion + "8";
                        break;
                    }
                    case "6.1": {
                        match.osVersion = match.osVersion + "7";
                        break;
                    }
                    case "6.0": {
                        match.osVersion = match.osVersion + "Vista";
                        break;
                    }
                    case "5.2": {
                        match.osVersion = match.osVersion + (found64 ? "XP x64 Edition or Server 2003" : "Server 2003");
                        break;
                    }
                    case "5.1": {
                        match.osVersion = match.osVersion + "XP";
                        break;
                    }
                    case "5.01": {
                        match.osVersion = match.osVersion + "2000 SP1";
                        break;
                    }
                    case "5.0": {
                        match.osVersion = match.osVersion + "2000";
                        break;
                    }
                    case "4.0": {
                        match.osVersion = match.osVersion + "NT 4.0";
                        break;
                    }
                    default: {
                        match.osVersion = version.startsWith("10.") ? match.osVersion + version : null;
                    }
                }
            }
            if (v.contains("windows nt 10.0")) {
                match.osVersion = "Windows 10";
            } else if (v.contains("windows nt 6.2; wow64") || v.contains("windows nt 6.2;win64")) {
                match.osVersion = "Windows 8";
                match.osFlavor = "64 bits";
            } else if (v.contains("windows nt 6.1;wow64")) {
                match.osVersion = "Windows 7";
                match.osFlavor = "64 bits";
            } else if (v.contains("windows nt 6.1")) {
                match.osVersion = "Windows 7";
                match.osFlavor = "32 bits";
            } else if (v.contains("windows nt 6.0")) {
                match.osVersion = "Windows Vista";
            }
        } else if (v.contains("linux")) {
            match.os = "Linux";
            if (v.contains("ubuntu")) {
                match.osFlavor = "Ubuntu";
            } else if (v.contains("debian")) {
                match.osFlavor = "Debian";
            } else if (v.contains("fedora")) {
                match.osFlavor = "Fedora";
            } else if (v.contains("redhat")) {
                match.osFlavor = "Redhat";
            }
        }
    }

    private void initClassifier() {
        this.addSimpleBot("Google", "Googlebot/", true);
        this.addSimpleBot("Google", "Googlebot-Image/", false);
        this.addSimpleBot("Voila", "VoilaBot BETA 1.2 ", false);
        this.addSimpleBot("Bing", "bingbot/", false);
        this.addSimpleBot("Yahoo", "Yahoo! Slurp", false);
        this.addSimpleBot("Baidu", "Baiduspider/", false);
        this.addSimpleBot("Baidu", "Baiduspider+", false);
        this.addSimpleBot("Soso", "Sosospider", false);
        this.addSimpleBot("Yandex", "YandexBot/", false);
        this.addSimpleBot("Sogou", "Sogou web spider", false);
        this.addSimpleBot("Sogou", "New-Sogou-Spider/", false);
        this.addSimpleBot("Exalead", "Exabot/3.0", false);
        this.addSimpleBot("Google (mobile)", "Googlebot-Mobile/", false);
        this.addSimpleBot("Twitter", "Twitterbot/", false);
        this.addSimpleBot("Blekko", "Blekkobot; ScoutJet;", false);
        this.addSimpleBot("Facebook hit", "facebookexternalhit/", false);
        this.addSimpleBot("Facebook scraper", "facebookscraper/", false);
        this.addSimpleBot("Genio", "http://www.genieo.com/webfilter.html", false);
        this.addSimpleBot("NHN", "http://help.naver.com/robots/", false);
        this.addSimpleBot("Showyou", "ShowyouBot", false);
        this.addSimpleBot("Tweetmeme", "TweetmemeBot", false);
        this.addSimpleBot("Alexa", "http://www.alexa.com/site/help/webmasters;", false);
        this.addSimpleBot("Mail.RU", "Mail.RU_Bot/2.0", false);
        this.addSimpleBot("Archive.org", "archive.org_bot", false);
        this.addSimpleBot("Bing", "BingPreview", false);
        this.addSimpleBot("Ahrefs", "AhrefsBot", false);
        this.addSimpleBot("Proximic", "www.proximic.com", false);
        this.addSimpleBot("MSN", "msnbot", false);
        this.addSimpleBot("Yandex", "YandexImages", false);
        this.addSimpleRSS("Google (RSS)", "Feedfetcher-Google", false);
        this.addSimpleRSS("Magpie", "MagpieRSS/0.", false);
        this.addSimpleRSS("Apple Syndication", "AppleSyndication/", false);
        this.addSimpleRSS("Feedly", "Feedly/", false);
        this.addSimpleLibrary("Adobe AIR", "AdobeAIR/", true);
        this.addSimpleLibrary("Apple PubSub", "Apple-PubSub/", false);
        this.addSimpleLibrary("Zend XML-RPC", "Zend_XmlRpc_Client", false);
        this.addSimpleLibrary("Zend HTTP", "Zend_Http_Client", false);
        this.addSimpleLibrary("Perl XML-RPC", "PEAR XML_RPC", false);
        this.addSimpleLibrary("Perl XML-RPC", "PEAR::XML_RPC2/", false);
        this.addSimpleLibrary("Perl XML-RPC", "RPC::XML::Client", false);
        this.addSimpleLibrary("PHP XML-RPC (Incutio)", "Incutio XML-RPC PHP", false);
        this.addSimpleLibrary("PHP XML-RPC", "XML-RPC for PHP", false);
        this.addSimpleLibrary("Apache XML-RPC (Java)", "Apache XML RPC 3.", false);
        this.addSimpleLibrary("XML-RPC.NET", "XML-RPC.NET", false);
        this.addSimpleLibrary("Ruby", "Ruby", false);
        this.addSimpleLibrary("cURL", "libcurl", false);
        this.addSimpleLibrary("curl", "libcurl", false);
        this.addSimpleLibrary("wget", "wget", false);
        this.addSimpleLibrary("wget", "Wget", false);
        this.addSimpleLibrary("Nagios", "check_http/", false);
        this.addSimpleLibrary("NewRelic", "NewRelicPinger/", false);
        this.addSimpleLibrary("Echoping", "Echoping/", false);
        this.addSimpleLibrary("PHP", "PHP/", false);
        this.addSimpleLibrary("JS-Kit", "JS-Kit URL Resolver", false);
        this.addSimpleLibrary("Jakarta Commons", "Jakarta Commons", false);
        this.addSimpleLibrary("Apache HTTP Client", "Apache-HTTPClient/", false);
        this.addSimpleLibrary("Google AppEngine", "AppEngine-Google", false);
        this.addSimpleLibrary("Python urllib", "Python-urllib/", false);
        this.firefox = new SafePatternMatcher(Pattern.compile(".*gecko/[0-9\\.]{4,} .*firefox/([^ ]*).*"));
        this.firefoxOldVersions = new SafePatternMatcher(Pattern.compile("^0\\..*|1\\..*|2\\..*|3\\.0.*|3\\.1.*|3\\.5.*|3\\.6.*"));
        this.ie = new SafePatternMatcher(Pattern.compile(".*msie ([^;]*);.*"));
        this.ie11 = new SafePatternMatcher(Pattern.compile(".*trident/7.0;.* rv:([^;\\)]*).*"));
        this.iosVersioniPhone = new SafePatternMatcher(Pattern.compile("cpu iphone os ([^ ]*) like"));
        this.iosVersioniPad = new SafePatternMatcher(Pattern.compile("ipad;.*cpu os ([^ ]*) like"));
        this.androidVersionMatcher = new SafePatternMatcher(Pattern.compile("android ([^;]*)"));
        this.winPhoneVersionMatcher = new SafePatternMatcher(Pattern.compile("windows phone ([^; ]*)"));
        this.macOSXVersionMatcher = new SafePatternMatcher(Pattern.compile("mac os x (10(?:[_.]\\d++)++)"));
        this.windowsVersionMatcher = new SafePatternMatcher(Pattern.compile("windows nt (\\d++\\.\\d++)\\b"));
        this.windowsBitsMatcher = new SafePatternMatcher(Pattern.compile("\\b(?:win|wow|x|ia)(32|64)\\b"));
        this.addBrowserWithVersion("browser", "Edge", "Edge", "KHTML.*Edge/([^ ]*)");
        this.addBrowserWithVersion("browser", "Chrome", "Chrome", "KHTML.*Chrome/([^ ]*)");
        this.addBrowserWithVersion("browser", "Safari", "Safari", "AppleWebKit/.*KHTML.*Version/([^ ]*).*Safari");
        this.addBrowserWithVersion("browser", "Safari", "AppleWebKit", "AppleWebKit/.*KHTML.*Safari/([^ ])");
        this.addBrowserWithVersion("browser", "Opera", "Opera", "Opera/9.80.*Version/(.*)");
        this.addBrowserWithVersion("browser", "Netscape", "Netscape", ".*Netscape/([^ ]*).*");
    }

    private void addSimpleMatch(String brand, String type, String lookup, boolean beginning) {
        if (beginning) {
            this.beginMatches.add(new SimpleMatcher(brand, type, lookup));
        } else {
            this.endMatches.add(new SimpleMatcher(brand, type, lookup));
        }
    }

    private void addSimpleBot(String brand, String lookup, boolean beginning) {
        this.addSimpleMatch(brand, "bot", lookup, beginning);
    }

    private void addSimpleLibrary(String brand, String lookup, boolean beginning) {
        this.addSimpleMatch(brand, "library", lookup, beginning);
    }

    private void addSimpleRSS(String brand, String lookup, boolean beginning) {
        this.addSimpleMatch(brand, "rss", lookup, beginning);
    }

    private void addBrowserWithVersion(String type, String brand, String fastFilter, String pattern) {
        this.browserMatchers.add(new PatternBrowserWithVersionMatcher(type, brand, fastFilter, pattern));
    }

    public static class UserAgentMatch {
        String type;
        String category;
        String brand;
        String version;
        String os;
        String osVersion;
        String osFlavor;
    }

    static class SimpleMatcher {
        String type;
        String brand;
        String lookup;

        SimpleMatcher(String brand, String type, String lookup) {
            this.brand = brand;
            this.type = type;
            this.lookup = lookup.toLowerCase();
        }

        boolean matches(String x) {
            return x.contains(this.lookup);
        }
    }

    class PatternBrowserWithVersionMatcher {
        SafePatternMatcher matcher;
        String type;
        String fastFilter;
        String brand;

        PatternBrowserWithVersionMatcher(String type, String brand, String fastFilter, String pattern) {
            this.type = type;
            this.brand = brand;
            this.fastFilter = fastFilter.toLowerCase();
            this.matcher = new SafePatternMatcher(pattern.toLowerCase());
        }

        boolean matchAndFill(String v, UserAgentMatch uam) {
            if (this.fastFilter != null && !v.contains(this.fastFilter)) {
                return false;
            }
            String s = this.matcher.findAndGetFirst(v);
            if (s != null) {
                uam.type = this.type;
                uam.category = this.brand;
                uam.brand = this.brand;
                uam.version = s;
                UserAgentClassifierAlgorithm.this.detectOS(v, uam);
                return true;
            }
            return false;
        }
    }
}

