/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractAnumMeaning;
import com.dataiku.dip.utils.FastSafePatternMatcher;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Measure
extends AbstractAnumMeaning {
    private static final Pattern MEASURE_REX = Pattern.compile("(\\d*[.,]?\\d+)\\s*(lbs?|oz|mg|g|kg|ton|mm|fl oz|ml|(cm|dm|m|km)[23]?|l|dl|cl)", 2);
    private static final NumberFormat FORMATTER = NumberFormat.getNumberInstance(Locale.FRENCH);
    private static final FastSafePatternMatcher MATCHER = new FastSafePatternMatcher(MEASURE_REX);

    public static double parseDouble(String val) {
        try {
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            try {
                Number n = FORMATTER.parse(val);
                return n.doubleValue();
            }
            catch (Exception ee) {
                return Double.NaN;
            }
        }
    }

    public static String normalize(String val) {
        Matcher m = MEASURE_REX.matcher(val);
        if (!m.find()) {
            return null;
        }
        double v = Measure.parseDouble(m.group(1));
        Unit u = Unit.valueOf(m.group(2).toLowerCase().replace(" ", ""));
        if (u.target == null) {
            return v + u.toString();
        }
        return v * u.multiplier + u.target.toString();
    }

    @Override
    public double detects(String val) {
        if (val == null) {
            return 0.0;
        }
        if (val.length() > 100) {
            return 0.0;
        }
        if (MATCHER.find(val)) {
            return 0.009;
        }
        return 0.0;
    }

    static enum Unit {
        g(null, 1.0),
        mg(g, 0.001),
        kg(g, 1000.0),
        ton(g, 1000000.0),
        lb(g, 453.59237),
        lbs(g, 453.59237),
        oz(g, 28.3495231),
        m(null, 1.0),
        mm(m, 0.001),
        cm(m, 0.01),
        dm(m, 0.1),
        km(m, 1000.0),
        l(null, 1.0),
        floz(l, 0.0295735296),
        dl(l, 0.1),
        cl(l, 0.01),
        ml(l, 0.001);

        Unit target;
        double multiplier;

        private Unit(Unit target, double multiplier) {
            this.target = target;
            this.multiplier = multiplier;
        }
    }
}

