/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractDoubleMeaning;
import com.dataiku.dip.utils.FastSafePatternMatcher;

public class Number
extends AbstractDoubleMeaning {
    private static final String DOUBLE_REGEXP = "[\\x00-\\x20]*[+-]?(((((\\p{Digit}+)([\\.,])?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))))[\\x00-\\x20]*";
    private static final FastSafePatternMatcher MATCHER = new FastSafePatternMatcher("[\\x00-\\x20]*[+-]?(((((\\p{Digit}+)([\\.,])?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))))[\\x00-\\x20]*");

    @Override
    public double doubleValue(String val) {
        if (this.validates(val)) {
            return Double.parseDouble(val.replace(',', '.'));
        }
        return Double.NaN;
    }

    @Override
    public double detects(String v) {
        if (v == null) {
            return 0.0;
        }
        if (MATCHER.matches(v)) {
            return 0.25;
        }
        return 0.0;
    }
}

