/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.text.ChoiceFormat;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.Classes;

public final class XMath {
    private XMath() {
    }

    private static float next(float f, boolean positive) {
        int SIGN = Integer.MIN_VALUE;
        int POSITIVEINFINITY = 2139095040;
        if (Float.isNaN(f)) {
            return f;
        }
        if (f == 0.0f) {
            float smallestPositiveFloat = Float.intBitsToFloat(1);
            return positive ? smallestPositiveFloat : -smallestPositiveFloat;
        }
        int bits = Float.floatToIntBits(f);
        int magnitude = bits & Integer.MAX_VALUE;
        if (bits > 0 == positive) {
            if (magnitude != 2139095040) {
                ++magnitude;
            }
        } else {
            --magnitude;
        }
        int signbit = bits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitude | signbit);
    }

    public static float next(float f) {
        return XMath.next(f, true);
    }

    public static float previous(float f) {
        return XMath.next(f, false);
    }

    public static double next(double f) {
        return ChoiceFormat.nextDouble(f);
    }

    public static double previous(double f) {
        return ChoiceFormat.previousDouble(f);
    }

    public static double rool(Class type, double value, int amount) throws IllegalArgumentException {
        if (Double.class.equals((Object)type)) {
            if (amount < 0) {
                do {
                    value = XMath.previous(value);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    value = XMath.next(value);
                } while (--amount != 0);
            }
            return value;
        }
        if (Float.class.equals((Object)type)) {
            float vf = (float)value;
            if (amount < 0) {
                do {
                    vf = XMath.previous(vf);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    vf = XMath.next(vf);
                } while (--amount != 0);
            }
            return vf;
        }
        if (Classes.isInteger(type)) {
            return value + (double)amount;
        }
        throw new IllegalArgumentException(Errors.format(199, type));
    }
}

