/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.CreateCredentialRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.CredentialInfo;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.CredentialsImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.CredentialsService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.DeleteCredentialRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GenerateTemporaryServiceCredentialRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetCredentialRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ListCredentialsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ListCredentialsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.TemporaryCredentials;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UpdateCredentialRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ValidateCredentialRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ValidateCredentialResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CredentialsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialsAPI.class);
    private final CredentialsService impl;

    public CredentialsAPI(ApiClient apiClient) {
        this.impl = new CredentialsImpl(apiClient);
    }

    public CredentialsAPI(CredentialsService mock) {
        this.impl = mock;
    }

    public CredentialInfo createCredential(String name) {
        return this.createCredential(new CreateCredentialRequest().setName(name));
    }

    public CredentialInfo createCredential(CreateCredentialRequest request) {
        return this.impl.createCredential(request);
    }

    public void deleteCredential(String nameArg) {
        this.deleteCredential(new DeleteCredentialRequest().setNameArg(nameArg));
    }

    public void deleteCredential(DeleteCredentialRequest request) {
        this.impl.deleteCredential(request);
    }

    public TemporaryCredentials generateTemporaryServiceCredential(String credentialName) {
        return this.generateTemporaryServiceCredential(new GenerateTemporaryServiceCredentialRequest().setCredentialName(credentialName));
    }

    public TemporaryCredentials generateTemporaryServiceCredential(GenerateTemporaryServiceCredentialRequest request) {
        return this.impl.generateTemporaryServiceCredential(request);
    }

    public CredentialInfo getCredential(String nameArg) {
        return this.getCredential(new GetCredentialRequest().setNameArg(nameArg));
    }

    public CredentialInfo getCredential(GetCredentialRequest request) {
        return this.impl.getCredential(request);
    }

    public Iterable<CredentialInfo> listCredentials(ListCredentialsRequest request) {
        return new Paginator(request, this.impl::listCredentials, ListCredentialsResponse::getCredentials, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CredentialInfo updateCredential(String nameArg) {
        return this.updateCredential(new UpdateCredentialRequest().setNameArg(nameArg));
    }

    public CredentialInfo updateCredential(UpdateCredentialRequest request) {
        return this.impl.updateCredential(request);
    }

    public ValidateCredentialResponse validateCredential(ValidateCredentialRequest request) {
        return this.impl.validateCredential(request);
    }

    public CredentialsService impl() {
        return this.impl;
    }
}

