/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.CurrentWorkspaceBindings;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetBindingsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetBindingsSecurableType;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetWorkspaceBindingRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UpdateBindingsSecurableType;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UpdateWorkspaceBindings;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UpdateWorkspaceBindingsParameters;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.WorkspaceBinding;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.WorkspaceBindingsImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.WorkspaceBindingsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.WorkspaceBindingsService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class WorkspaceBindingsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceBindingsAPI.class);
    private final WorkspaceBindingsService impl;

    public WorkspaceBindingsAPI(ApiClient apiClient) {
        this.impl = new WorkspaceBindingsImpl(apiClient);
    }

    public WorkspaceBindingsAPI(WorkspaceBindingsService mock) {
        this.impl = mock;
    }

    public CurrentWorkspaceBindings get(String name) {
        return this.get(new GetWorkspaceBindingRequest().setName(name));
    }

    public CurrentWorkspaceBindings get(GetWorkspaceBindingRequest request) {
        return this.impl.get(request);
    }

    public Iterable<WorkspaceBinding> getBindings(GetBindingsSecurableType securableType, String securableName) {
        return this.getBindings(new GetBindingsRequest().setSecurableType(securableType).setSecurableName(securableName));
    }

    public Iterable<WorkspaceBinding> getBindings(GetBindingsRequest request) {
        return new Paginator(request, this.impl::getBindings, WorkspaceBindingsResponse::getBindings, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CurrentWorkspaceBindings update(String name) {
        return this.update(new UpdateWorkspaceBindings().setName(name));
    }

    public CurrentWorkspaceBindings update(UpdateWorkspaceBindings request) {
        return this.impl.update(request);
    }

    public WorkspaceBindingsResponse updateBindings(UpdateBindingsSecurableType securableType, String securableName) {
        return this.updateBindings(new UpdateWorkspaceBindingsParameters().setSecurableType(securableType).setSecurableName(securableName));
    }

    public WorkspaceBindingsResponse updateBindings(UpdateWorkspaceBindingsParameters request) {
        return this.impl.updateBindings(request);
    }

    public WorkspaceBindingsService impl() {
        return this.impl;
    }
}

