/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.io;

import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.io.FileLocationStrategy;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.io.FileLocator;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.io.FileLocatorUtils;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.io.FileSystem;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.lang3.SystemProperties;
import java.io.File;
import java.net.URL;

public class HomeDirectoryLocationStrategy
implements FileLocationStrategy {
    private final String homeDirectory;
    private final boolean evaluateBasePath;

    private static String fetchHomeDirectory(String homeDir) {
        return homeDir != null ? homeDir : SystemProperties.getUserName();
    }

    public HomeDirectoryLocationStrategy() {
        this(false);
    }

    public HomeDirectoryLocationStrategy(boolean withBasePath) {
        this(null, withBasePath);
    }

    public HomeDirectoryLocationStrategy(String homeDir, boolean withBasePath) {
        this.homeDirectory = HomeDirectoryLocationStrategy.fetchHomeDirectory(homeDir);
        this.evaluateBasePath = withBasePath;
    }

    private String fetchBasePath(FileLocator locator) {
        if (this.isEvaluateBasePath() && StringUtils.isNotEmpty(locator.getBasePath())) {
            return FileLocatorUtils.appendPath(this.getHomeDirectory(), locator.getBasePath());
        }
        return this.getHomeDirectory();
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public boolean isEvaluateBasePath() {
        return this.evaluateBasePath;
    }

    @Override
    public URL locate(FileSystem fileSystem, FileLocator locator) {
        String basePath;
        File file;
        if (StringUtils.isNotEmpty(locator.getFileName()) && (file = FileLocatorUtils.constructFile(basePath = this.fetchBasePath(locator), locator.getFileName())).isFile()) {
            return FileLocatorUtils.convertFileToURL(file);
        }
        return null;
    }
}

