/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureProgressStateSnapshot;
import com.dataiku.dip.plugin.ProgressTracker;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.List;

public class FutureProgress {
    static ThreadLocal<FutureProgress> localFP = new InheritableThreadLocal<FutureProgress>(){

        @Override
        public FutureProgress childValue(FutureProgress parentValue) {
            if (parentValue != null) {
                return new FutureProgress(parentValue);
            }
            return new FutureProgress(null);
        }
    };
    public final int depth;
    private final FutureProgress parent;
    private List<WeakReference<FutureProgress>> subProgresses = Lists.newLinkedList();
    public FutureProgressStateSnapshot stateStack = new FutureProgressStateSnapshot();

    private synchronized void addSubProgress(FutureProgress progress) {
        this.cleanupGarbageCollectedSubprogresses();
        this.subProgresses.add(new WeakReference<FutureProgress>(progress));
    }

    FutureProgress(FutureProgress parent) {
        this.depth = parent == null ? 0 : parent.depth + 1;
        this.parent = parent;
        if (parent != null) {
            parent.addSubProgress(this);
        }
    }

    public static FutureProgress init() {
        if (localFP.get() != null) {
            return localFP.get();
        }
        FutureProgress fp = new FutureProgress(null);
        localFP.set(fp);
        return fp;
    }

    public static void deinit() {
        localFP.remove();
    }

    public static FutureProgress getLocalDangerous() {
        if (localFP.get() == null) {
            return null;
        }
        return localFP.get();
    }

    public static AutocloseableFutureProgressState pushAutoCloseableState(String name) {
        return FutureProgress.pushAutoCloseableState(name, -1.0, FutureProgressState.StateUnit.NONE);
    }

    public static AutocloseableFutureProgressStateWithAutoincrement pushAutoCloseableState(String name, double autoIncrementAtClosing) {
        return FutureProgress.pushAutoCloseableState(name, -1.0, FutureProgressState.StateUnit.NONE, autoIncrementAtClosing);
    }

    public static FutureProgressState pushState(String name) {
        return FutureProgress.pushState(name, -1.0, FutureProgressState.StateUnit.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FutureProgressState pushState(String name, double target, FutureProgressState.StateUnit unit) {
        FutureProgress futureProgress = localFP.get();
        if (futureProgress == null) {
            return new FutureProgressState("No progress tracking", 0);
        }
        FutureProgress futureProgress2 = futureProgress;
        synchronized (futureProgress2) {
            FutureProgressState state = new FutureProgressState(name, unit, target, futureProgress.depth);
            futureProgress.stateStack.push(state);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutocloseableFutureProgressState pushAutoCloseableState(String name, double target, FutureProgressState.StateUnit unit) {
        FutureProgress futureProgress = localFP.get();
        if (futureProgress == null) {
            return new AutocloseableFutureProgressState("No progress tracking", 0);
        }
        FutureProgress futureProgress2 = futureProgress;
        synchronized (futureProgress2) {
            AutocloseableFutureProgressState state = new AutocloseableFutureProgressState(name, unit, target, futureProgress.depth);
            futureProgress.stateStack.push(state);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutocloseableFutureProgressStateWithAutoincrement pushAutoCloseableState(String name, double target, FutureProgressState.StateUnit unit, double autoIncrementAtClosing) {
        FutureProgress futureProgress = localFP.get();
        if (futureProgress == null) {
            return new AutocloseableFutureProgressStateWithAutoincrement("No progress tracking", 0);
        }
        FutureProgress futureProgress2 = futureProgress;
        synchronized (futureProgress2) {
            AutocloseableFutureProgressStateWithAutoincrement state = new AutocloseableFutureProgressStateWithAutoincrement(name, unit, target, futureProgress.depth, autoIncrementAtClosing);
            futureProgress.stateStack.push(state);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popState() {
        FutureProgress futureProgress = localFP.get();
        if (futureProgress == null) {
            return;
        }
        FutureProgress futureProgress2 = futureProgress;
        synchronized (futureProgress2) {
            futureProgress.stateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FutureProgressState peekState() {
        FutureProgress futureProgress = localFP.get();
        if (futureProgress == null) {
            return null;
        }
        FutureProgress futureProgress2 = futureProgress;
        synchronized (futureProgress2) {
            return futureProgress.stateStack.safePeek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FutureProgressState getState() {
        FutureProgress futureProgress = localFP.get();
        if (futureProgress == null) {
            return new FutureProgressState("No state", 0);
        }
        FutureProgress futureProgress2 = futureProgress;
        synchronized (futureProgress2) {
            FutureProgressState state = futureProgress.stateStack.safePeek();
            if (state == null) {
                FutureProgress fp = futureProgress.parent;
                while (fp != null && state == null) {
                    state = fp.stateStack.safePeek();
                    fp = fp.parent;
                }
            }
            return state != null ? state : new FutureProgressState("No state", 0);
        }
    }

    public static void updateState(double cur) throws InterruptedException {
        if (localFP.get() == null) {
            return;
        }
        FutureProgress.getState().set(cur);
    }

    public static void incrementState(double amount) throws InterruptedException {
        if (localFP.get() == null) {
            return;
        }
        FutureProgress.getState().increment(amount);
    }

    private synchronized void cleanupGarbageCollectedSubprogresses() {
        this.subProgresses.removeIf(ref -> ref.get() == null);
    }

    public synchronized FutureProgressStateSnapshot getSnapshot() {
        FutureProgressStateSnapshot snapshot = this.stateStack.getSnapshot();
        this.cleanupGarbageCollectedSubprogresses();
        for (WeakReference<FutureProgress> subProgressRef : this.subProgresses) {
            FutureProgress subProgress = (FutureProgress)subProgressRef.get();
            if (subProgress == null) continue;
            for (FutureProgressState state : subProgress.getSnapshot().states) {
                snapshot.push(state);
            }
        }
        return snapshot;
    }

    public static class AutocloseableFutureProgressState
    extends FutureProgressState
    implements AutoCloseable,
    ProgressTracker.ProgressTrackerState {
        public AutocloseableFutureProgressState(String name, FutureProgressState.StateUnit unit, double target, int depth) {
            super(name, unit, target, depth);
        }

        public AutocloseableFutureProgressState(String name, int depth) {
            super(name, depth);
        }

        @Override
        public void close() {
            FutureProgress.popState();
        }
    }

    public static class AutocloseableFutureProgressStateWithAutoincrement
    extends FutureProgressState
    implements AutoCloseable,
    ProgressTracker.ProgressTrackerState {
        private double autoIncrementAtClosing = 0.0;

        public AutocloseableFutureProgressStateWithAutoincrement(String name, FutureProgressState.StateUnit unit, double target, int depth, double autoIncrementAtClosing) {
            super(name, unit, target, depth);
            this.autoIncrementAtClosing = autoIncrementAtClosing;
        }

        public AutocloseableFutureProgressStateWithAutoincrement(String name, int depth) {
            super(name, depth);
        }

        @Override
        public void close() throws InterruptedException {
            FutureProgress.popState();
            if (this.autoIncrementAtClosing > 0.0) {
                FutureProgress.incrementState(this.autoIncrementAtClosing);
            }
        }
    }
}

