/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.PasswordEncryptionProvider;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretString;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RegularPasswordEncryptionService
implements PasswordEncryptionService {
    private PasswordEncryptionProvider provider;

    private RegularPasswordEncryptionService() throws Exception {
        this.reinit();
    }

    private RegularPasswordEncryptionService(PasswordEncryptionProvider provider) throws Exception {
        this.provider = provider;
        this.provider.init(null);
    }

    public static RegularPasswordEncryptionService withExplicitProvider(PasswordEncryptionProvider provider) throws Exception {
        return new RegularPasswordEncryptionService(provider);
    }

    public void reinit() throws Exception {
        String providerClazz = DKUApp.getParams().getParam("dku.passwordEncryption.provider.class", "com.dataiku.dip.security.ConfigFileSymmetricKeyBasedPasswordEncryptionProvider");
        String providerConfig = DKUApp.getParams().getParam("dku.passwordEncryption.provider.settings");
        this.provider = (PasswordEncryptionProvider)Class.forName(providerClazz).newInstance();
        SpringUtils.getInstance().autowire(this.provider);
        this.provider.init(providerConfig);
    }

    @Override
    public String encrypt(String password) {
        try {
            return this.provider.encrypt(password);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to encrypt password", e);
        }
    }

    @Override
    public String encryptIfNotEncryptedOrEmpty(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return null;
        }
        try {
            return this.provider.encryptIfNotEncrypted(password);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to encrypt password", e);
        }
    }

    @Override
    public String decryptIfEncrypted(String password) {
        try {
            return this.provider.decryptIfEncrypted(password);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decrypt password", e);
        }
    }

    @Override
    public SecretString encrypt(SecretString secretString) {
        if (secretString == null) {
            return null;
        }
        return SecretString.buildOrNull(this.encrypt(secretString.secret));
    }

    @Override
    public SecretString encryptIfNotEncryptedOrEmpty(SecretString secretString) {
        if (secretString == null) {
            return null;
        }
        return SecretString.buildOrNull(this.encryptIfNotEncryptedOrEmpty(secretString.secret));
    }

    @Override
    public SecretString decryptIfEncrypted(SecretString secretString) {
        if (secretString == null) {
            return null;
        }
        return SecretString.buildOrNull(this.decryptIfEncrypted(secretString.secret));
    }
}

