/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.dao.DkuProfilingDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUProfiler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;

public abstract class DkuBackendProfilingService<T extends DkuProfilingDAO.DkuProfilerSettings>
implements ApplicationListener<DSSStartedEvent> {
    @Autowired
    DkuProfilingDAO<T> profilingDAO;
    private final DKUProfiler profiler = new DKUProfiler();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.profiler.backend");

    public List<DKUProfiler.PerformanceProfile> listProfiles() {
        return this.profiler.listProfiles();
    }

    public File getProfileFile(String profileId) throws IOException {
        return this.profiler.getProfileFile(profileId);
    }

    public void deleteProfile(String profileId) throws IOException {
        this.profiler.deleteProfile(profileId);
    }

    public void saveConfig(T settings) throws IOException {
        this.profilingDAO.saveProfilerSettings(settings);
        TransactionContext.retrieveWrite().onPostCommit(this::updateProfilerState_NT);
    }

    public T getConfig() throws IOException {
        return this.profilingDAO.getProfilerSettings_AutoTXN();
    }

    private void updateProfilerState_NT() {
        try {
            T profilerSettings = this.profilingDAO.getProfilerSettings_AutoTXN();
            DKUProfiler.ProfilerConfiguration profilerConfiguration = new DKUProfiler.ProfilerConfiguration();
            profilerConfiguration.directory = DKUApp.getFile("run", "profiles");
            profilerConfiguration.maxSizeMB = ((DkuProfilingDAO.DkuProfilerSettings)profilerSettings).maxSizeMB;
            profilerConfiguration.jfrConfigName = ((DkuProfilingDAO.DkuProfilerSettings)profilerSettings).jfrConfigName;
            this.profiler.setConfiguration(profilerConfiguration);
            this.profiler.setEnabled(((DkuProfilingDAO.DkuProfilerSettings)profilerSettings).backendProfilingEnabled);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update profiler state", (Throwable)e);
        }
    }

    public void onApplicationEvent(DSSStartedEvent dssStartedEvent) {
        new Thread(() -> {
            logger.info((Object)"Configuring profiler state");
            this.updateProfilerState_NT();
        }).start();
    }
}

