/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.filtering;

import com.dataiku.dip.agents.tools.filtering.SimpleFilterClause;
import com.dataiku.dip.agents.tools.utils.JsonSchemaElement;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SimpleFilter
extends SimpleFilterClause {
    private static ValueType assignFromValue(FilterDesc.FilterUiCondition cond, JsonElement value) {
        if (value.isJsonPrimitive()) {
            JsonPrimitive primitiveValue = value.getAsJsonPrimitive();
            if (primitiveValue.isNumber()) {
                cond.num = primitiveValue.getAsDouble();
                return ValueType.NUMBER;
            }
            cond.string = primitiveValue.getAsString();
            return ValueType.STRING;
        }
        return ValueType.OTHER;
    }

    private static FilterDesc.FilterUiCondition condFromClause(SimpleFilterClause clause) throws IllegalArgumentException {
        FilterDesc.FilterUiCondition cond = new FilterDesc.FilterUiCondition();
        clause.validate();
        switch (clause.operator) {
            case EQUALS: {
                ValueType vt = SimpleFilter.assignFromValue(cond, clause.value);
                cond.operator = vt == ValueType.NUMBER ? FilterDesc.FilterUiOperator.EQUALS_NUMBER.getRepr() : FilterDesc.FilterUiOperator.EQUALS_STRING.getRepr();
                cond.input = clause.column;
                break;
            }
            case NOT_EQUALS: {
                ValueType vt = SimpleFilter.assignFromValue(cond, clause.value);
                cond.operator = vt == ValueType.NUMBER ? FilterDesc.FilterUiOperator.NOT_EQUALS_NUMBER.getRepr() : FilterDesc.FilterUiOperator.NOT_EQUALS_STRING.getRepr();
                cond.input = clause.column;
                cond.string = clause.value.getAsString();
                break;
            }
            case GREATER_THAN: {
                cond.operator = FilterDesc.FilterUiOperator.GREATER_NUMBER.getRepr();
                cond.input = clause.column;
                cond.num = clause.value.getAsDouble();
                break;
            }
            case LESS_THAN: {
                cond.operator = FilterDesc.FilterUiOperator.LESS_NUMBER.getRepr();
                cond.input = clause.column;
                cond.num = clause.value.getAsDouble();
                break;
            }
            case GREATER_OR_EQUAL: {
                cond.operator = FilterDesc.FilterUiOperator.GREATER_OR_EQUAL_NUMBER.getRepr();
                cond.input = clause.column;
                cond.num = clause.value.getAsDouble();
                break;
            }
            case LESS_OR_EQUAL: {
                cond.operator = FilterDesc.FilterUiOperator.LESS_OR_EQUAL_NUMBER.getRepr();
                cond.input = clause.column;
                cond.num = clause.value.getAsDouble();
                break;
            }
            case DEFINED: {
                cond.operator = FilterDesc.FilterUiOperator.NOT_EMPTY.getRepr();
                cond.input = clause.column;
                break;
            }
            case NOT_DEFINED: {
                cond.operator = FilterDesc.FilterUiOperator.EMPTY.getRepr();
                cond.input = clause.column;
                break;
            }
            case CONTAINS: {
                cond.operator = FilterDesc.FilterUiOperator.CONTAINS_STRING.getRepr();
                cond.input = clause.column;
                cond.string = clause.value.getAsString();
                break;
            }
            case MATCHES: {
                cond.operator = FilterDesc.FilterUiOperator.REGEX.getRepr();
                cond.input = clause.column;
                cond.string = clause.value.getAsString();
                break;
            }
            case IN_ANY_OF: 
            case IN_NONE_OF: {
                assert (clause.value.isJsonArray());
                boolean isNumerical = false;
                JsonArray values = clause.value.getAsJsonArray();
                if (!values.isEmpty()) {
                    JsonPrimitive primitiveValue = values.get(0).getAsJsonPrimitive();
                    isNumerical = primitiveValue.isNumber();
                }
                cond.operator = isNumerical ? (clause.operator == SimpleFilterClause.Operator.IN_ANY_OF ? FilterDesc.FilterUiOperator.IN_ANY_OF_NUMBER.getRepr() : FilterDesc.FilterUiOperator.IN_NONE_OF_NUMBER.getRepr()) : (clause.operator == SimpleFilterClause.Operator.IN_ANY_OF ? FilterDesc.FilterUiOperator.IN_ANY_OF_STRING.getRepr() : FilterDesc.FilterUiOperator.IN_NONE_OF_STRING.getRepr());
                cond.input = clause.column;
                cond.items = new ArrayList();
                for (JsonElement value : values) {
                    FilterDesc.FilterUiListConditionValue uiConditionValue = new FilterDesc.FilterUiListConditionValue();
                    if (isNumerical) {
                        uiConditionValue.num = value.getAsDouble();
                    } else {
                        uiConditionValue.string = value.getAsString();
                    }
                    cond.items.add(uiConditionValue);
                }
                break;
            }
            case AND: {
                FilterDesc subFilter = new FilterDesc();
                subFilter.enabled = true;
                subFilter.uiData = new FilterDesc.FilterUiData();
                subFilter.uiData.mode = "&&";
                for (SimpleFilterClause subClause : clause.clauses) {
                    subFilter.uiData.conditions.add(SimpleFilter.condFromClause(subClause));
                }
                cond.subCondition = subFilter;
                break;
            }
            case OR: {
                FilterDesc subFilter = new FilterDesc();
                subFilter.enabled = true;
                subFilter.uiData = new FilterDesc.FilterUiData();
                subFilter.uiData.mode = "||";
                for (SimpleFilterClause subClause : clause.clauses) {
                    subFilter.uiData.conditions.add(SimpleFilter.condFromClause(subClause));
                }
                cond.subCondition = subFilter;
                break;
            }
        }
        return cond;
    }

    public FilterDesc toRealFilter() {
        this.validate();
        switch (this.operator) {
            case AND: 
            case OR: {
                FilterDesc.FilterUiCondition fakeCond = SimpleFilter.condFromClause(this);
                assert (fakeCond.subCondition != null);
                return fakeCond.subCondition;
            }
        }
        FilterDesc topFD = new FilterDesc();
        topFD.enabled = true;
        topFD.uiData = new FilterDesc.FilterUiData();
        topFD.uiData.mode = "&&";
        FilterDesc.FilterUiCondition cond = SimpleFilter.condFromClause(this);
        topFD.uiData.conditions.add(cond);
        return topFD;
    }

    public static SimpleFilterClause.Operator toOperator(String operator) {
        switch (operator) {
            case "== [column]": 
            case "== [NaNcolumn]": 
            case "== [string]": 
            case "== [number]": {
                return SimpleFilterClause.Operator.EQUALS;
            }
            case "!= [column]": 
            case "!= [number]": 
            case "!= [NaNcolumn]": 
            case "!= [string]": {
                return SimpleFilterClause.Operator.NOT_EQUALS;
            }
            case ">  [column]": 
            case ">  [number]": {
                return SimpleFilterClause.Operator.GREATER_THAN;
            }
            case "<  [column]": 
            case "<  [number]": {
                return SimpleFilterClause.Operator.LESS_THAN;
            }
            case ">= [column]": 
            case ">= [number]": {
                return SimpleFilterClause.Operator.GREATER_OR_EQUAL;
            }
            case "<= [column]": 
            case "<= [number]": {
                return SimpleFilterClause.Operator.LESS_OR_EQUAL;
            }
            case "in [string]": 
            case "in [number]": {
                return SimpleFilterClause.Operator.IN_ANY_OF;
            }
            case "not in [string]": 
            case "not in [number]": {
                return SimpleFilterClause.Operator.IN_NONE_OF;
            }
            case "is empty": {
                return SimpleFilterClause.Operator.NOT_DEFINED;
            }
            case "not empty": {
                return SimpleFilterClause.Operator.DEFINED;
            }
            case "contains": {
                return SimpleFilterClause.Operator.CONTAINS;
            }
            case "regex": {
                return SimpleFilterClause.Operator.MATCHES;
            }
            case "&&": {
                return SimpleFilterClause.Operator.AND;
            }
            case "||": {
                return SimpleFilterClause.Operator.OR;
            }
        }
        throw new IllegalArgumentException("Cannot convert to simple filter the operator " + operator);
    }

    private static SimpleFilterClause clauseFromCond(FilterDesc.FilterUiCondition cond, Optional<RowWithFactories> row) {
        if (cond.subCondition != null) {
            return SimpleFilter.fromComplexFilter(cond.subCondition, row);
        }
        SimpleFilterClause clause = new SimpleFilterClause();
        switch (cond.operator) {
            case "== [number]": {
                clause.operator = SimpleFilterClause.Operator.EQUALS;
                clause.column = cond.input;
                clause.value = new JsonPrimitive((Number)cond.num);
                break;
            }
            case "== [string]": {
                clause.operator = SimpleFilterClause.Operator.EQUALS;
                clause.column = cond.input;
                if (cond.string == null) {
                    throw new IllegalArgumentException("A string value is required for operator 'equal' on column '" + clause.column + "'");
                }
                clause.value = new JsonPrimitive(cond.string);
                break;
            }
            case "!= [number]": {
                clause.operator = SimpleFilterClause.Operator.NOT_EQUALS;
                clause.column = cond.input;
                clause.value = new JsonPrimitive((Number)cond.num);
                break;
            }
            case "!= [string]": {
                clause.operator = SimpleFilterClause.Operator.NOT_EQUALS;
                clause.column = cond.input;
                if (cond.string == null) {
                    throw new IllegalArgumentException("A string value is required for operator 'not equal' on column '" + clause.column + "'");
                }
                clause.value = new JsonPrimitive(cond.string);
                break;
            }
            case ">  [number]": {
                clause.operator = SimpleFilterClause.Operator.GREATER_THAN;
                clause.column = cond.input;
                clause.value = new JsonPrimitive((Number)cond.num);
                break;
            }
            case "<  [number]": {
                clause.operator = SimpleFilterClause.Operator.LESS_THAN;
                clause.column = cond.input;
                clause.value = new JsonPrimitive((Number)cond.num);
                break;
            }
            case ">= [number]": {
                clause.operator = SimpleFilterClause.Operator.GREATER_OR_EQUAL;
                clause.column = cond.input;
                clause.value = new JsonPrimitive((Number)cond.num);
                break;
            }
            case "<= [number]": {
                clause.operator = SimpleFilterClause.Operator.LESS_OR_EQUAL;
                clause.column = cond.input;
                clause.value = new JsonPrimitive((Number)cond.num);
                break;
            }
            case "in [number]": {
                clause.operator = SimpleFilterClause.Operator.IN_ANY_OF;
                clause.column = cond.input;
                if (cond.items == null || cond.items.isEmpty()) {
                    throw new IllegalArgumentException("A list of values is required for operator 'in' on column '" + clause.column + "'");
                }
                clause.value = new JsonArray(cond.items.size());
                cond.items.forEach(item -> ((JsonArray)clause.value).add((Number)item.num));
                break;
            }
            case "not in [number]": {
                clause.operator = SimpleFilterClause.Operator.IN_NONE_OF;
                clause.column = cond.input;
                if (cond.items == null || cond.items.isEmpty()) {
                    throw new IllegalArgumentException("A list of values is required for operator 'not in' on column '" + clause.column + "'");
                }
                clause.value = new JsonArray(cond.items.size());
                cond.items.forEach(item -> ((JsonArray)clause.value).add((Number)item.num));
                break;
            }
            case "in [string]": {
                clause.operator = SimpleFilterClause.Operator.IN_ANY_OF;
                clause.column = cond.input;
                if (cond.items == null || cond.items.isEmpty()) {
                    throw new IllegalArgumentException("A list of values is required for operator 'in' on column '" + clause.column + "'");
                }
                clause.value = new JsonArray(cond.items.size());
                cond.items.forEach(item -> {
                    if (item.string == null) {
                        throw new IllegalArgumentException("A string value is required for items of operator 'in' on column '" + clause.column + "'");
                    }
                    ((JsonArray)clause.value).add(item.string);
                });
                break;
            }
            case "not in [string]": {
                clause.operator = SimpleFilterClause.Operator.IN_NONE_OF;
                clause.column = cond.input;
                if (cond.items == null || cond.items.isEmpty()) {
                    throw new IllegalArgumentException("A list of values is required for operator 'not in' on column '" + clause.column + "'");
                }
                clause.value = new JsonArray(cond.items.size());
                cond.items.forEach(item -> {
                    if (item.string == null) {
                        throw new IllegalArgumentException("A string value is required for items of operator 'not in' on column '" + clause.column + "'");
                    }
                    ((JsonArray)clause.value).add(item.string);
                });
                break;
            }
            case "is empty": {
                clause.operator = SimpleFilterClause.Operator.NOT_DEFINED;
                clause.column = cond.input;
                break;
            }
            case "not empty": {
                clause.operator = SimpleFilterClause.Operator.DEFINED;
                clause.column = cond.input;
                break;
            }
            case "contains": {
                clause.operator = SimpleFilterClause.Operator.CONTAINS;
                clause.column = cond.input;
                if (cond.string == null) {
                    throw new IllegalArgumentException("A string value is required for operator 'contains' on column '" + clause.column + "'");
                }
                clause.value = new JsonPrimitive(cond.string);
                break;
            }
            case "regex": {
                clause.operator = SimpleFilterClause.Operator.MATCHES;
                clause.column = cond.input;
                if (cond.string == null) {
                    throw new IllegalArgumentException("A string value is required for operator 'regex' on column '" + clause.column + "'");
                }
                clause.value = new JsonPrimitive(cond.string);
                break;
            }
            case "== [NaNcolumn]": 
            case "== [column]": {
                SimpleFilter.applyDynamicFilterToClause(clause, cond, row, SimpleFilterClause.Operator.EQUALS);
                break;
            }
            case "!= [NaNcolumn]": 
            case "!= [column]": {
                SimpleFilter.applyDynamicFilterToClause(clause, cond, row, SimpleFilterClause.Operator.NOT_EQUALS);
                break;
            }
            case ">  [column]": {
                SimpleFilter.applyDynamicFilterToClause(clause, cond, row, SimpleFilterClause.Operator.GREATER_THAN);
                break;
            }
            case "<  [column]": {
                SimpleFilter.applyDynamicFilterToClause(clause, cond, row, SimpleFilterClause.Operator.LESS_THAN);
                break;
            }
            case ">= [column]": {
                SimpleFilter.applyDynamicFilterToClause(clause, cond, row, SimpleFilterClause.Operator.GREATER_OR_EQUAL);
                break;
            }
            case "<= [column]": {
                SimpleFilter.applyDynamicFilterToClause(clause, cond, row, SimpleFilterClause.Operator.LESS_OR_EQUAL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert to simple filter the operator " + cond.operator);
            }
        }
        return clause;
    }

    private static void applyDynamicFilterToClause(SimpleFilterClause clause, FilterDesc.FilterUiCondition cond, Optional<RowWithFactories> row, SimpleFilterClause.Operator operator) {
        clause.operator = operator;
        clause.column = cond.input;
        if (cond.col == null) {
            throw new IllegalArgumentException("A column name is required for operator '" + operator.description + "' on column '" + clause.column + "'");
        }
        if (row.isEmpty()) {
            throw new IllegalArgumentException("A row is required for operator '" + operator.description + "' on column '" + clause.column + "'");
        }
        ColumnFactory cf = row.get().getColumnFactory();
        String rowValue = row.get().getRow().get(cf.column(cond.col));
        if (rowValue == null) {
            throw new IllegalArgumentException("A value for column '" + cond.col + "' is required for operator '" + operator.description + "' in row " + String.valueOf(row));
        }
        clause.value = new JsonPrimitive(rowValue);
    }

    public static SimpleFilter fromComplexFilter(FilterDesc desc, Optional<RowWithFactories> row) {
        if (desc.uiData == null) {
            throw new IllegalArgumentException("can't convert a non-UI filter");
        }
        switch (desc.uiData.mode) {
            case "&&": {
                return SimpleFilter.getSimpleFilter(SimpleFilterClause.Operator.AND, desc.uiData.conditions, row);
            }
            case "||": {
                return SimpleFilter.getSimpleFilter(SimpleFilterClause.Operator.OR, desc.uiData.conditions, row);
            }
        }
        throw new IllegalArgumentException("Cannot convert to simple filter a filter of type " + desc.uiData.mode);
    }

    private static SimpleFilter getSimpleFilter(SimpleFilterClause.Operator operator, List<FilterDesc.FilterUiCondition> conditions, Optional<RowWithFactories> row) {
        SimpleFilter sf = new SimpleFilter();
        sf.operator = operator;
        sf.clauses = conditions.stream().map(c2 -> SimpleFilter.clauseFromCond(c2, row)).collect(Collectors.toList());
        if (sf.clauses.size() == 1) {
            return (SimpleFilter)JSON.parse((String)JSON.json(sf.clauses.get(0)), SimpleFilter.class);
        }
        return sf;
    }

    public static JsonSchemaElement jsonSchemaElement(String pathToMe, List<String> supportedOperators, @Nullable List<String> filterColumns) {
        String operatorStr = supportedOperators.stream().collect(Collectors.joining(", "));
        JsonSchemaElement filterClause = JsonSchemaElement.object("A filter (or clause)");
        filterClause.properties.put("operator", JsonSchemaElement.stringEnum("Filter operator. One of " + operatorStr, supportedOperators));
        filterClause.properties.put("column", JsonSchemaElement.stringEnum("On which column it applies. Not applicable to AND and OR", filterColumns));
        filterClause.properties.put("value", JsonSchemaElement.string("Value to compare. Not applicable to AND, OR, DEFINED, NOT_DEFINED. Either a string or a number for EQUALS, NOT_EQUALS, GREATER_THAN, GREATER_OR_EQUAL, LESS_THAN, LESS_OR_EQUAL, CONTAINS and MATCHES (regex). Either a list of strings or a list of numbers for IN_ANY_OF and IN_NONE_OF. Beware, don't put the value between quotes if you mean a number."));
        filterClause.properties.put("clauses", JsonSchemaElement.complexArray("Boolean clauses. Only applies to AND and OR. These sub-clauses are of the same type as the current element", JsonSchemaElement.ref(pathToMe)));
        return filterClause;
    }

    private static enum ValueType {
        STRING,
        NUMBER,
        OTHER;

    }
}

