/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class DecisionTreeStatusExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        return DecisionTreeStatusExtractor.isCompatible(model) ? "Yes" : "No";
    }

    private static boolean isCompatible(ModelDetailsBase model) {
        if (model instanceof ClassicalPredictionModelDetails) {
            ClassicalPredictionModelDetails predictionModel = (ClassicalPredictionModelDetails)model;
            if (DecisionTreeStatusExtractor.isPartitionedModel(predictionModel)) {
                return false;
            }
            return DecisionTreeStatusExtractor.isModelWithSingleTree(predictionModel) || DecisionTreeStatusExtractor.isModelWithMultipleTrees(predictionModel);
        }
        return false;
    }

    private static boolean isPartitionedModel(ClassicalPredictionModelDetails predictionModel) {
        return predictionModel.coreParams != null && predictionModel.coreParams.partitionedModel != null && predictionModel.coreParams.partitionedModel.enabled;
    }

    private static boolean isModelWithMultipleTrees(ClassicalPredictionModelDetails model) {
        if (model.modeling == null) {
            return false;
        }
        return model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.GBT_REGRESSION || model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.GBT_CLASSIFICATION || model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.RANDOM_FOREST_CLASSIFICATION || model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.RANDOM_FOREST_REGRESSION || model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.MLLIB_GBT || model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.MLLIB_RANDOM_FOREST && !DecisionTreeStatusExtractor.isMultiClass(model);
    }

    private static boolean isModelWithSingleTree(ClassicalPredictionModelDetails model) {
        if (model.modeling == null) {
            return false;
        }
        return model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.DECISION_TREE_REGRESSION || model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.DECISION_TREE_CLASSIFICATION || model.modeling.algorithm == PreTrainPredictionModelingParams.Algorithm.MLLIB_DECISION_TREE;
    }

    private static boolean isMultiClass(ClassicalPredictionModelDetails predictionModel) {
        return predictionModel.coreParams != null && predictionModel.coreParams.prediction_type.equals((Object)PredictionMLTask.PredictionType.MULTICLASS);
    }
}

