/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.warnings.WarningsContext;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ResultsDiagnosticsTableExtractor
implements ModelExtractor<List<List<String>>> {
    public static final String NOTHING_TO_REPORT = "Nothing to report";
    public static final String SINGLE_DISABLED = "Disabled";
    public static final String ALL_DISABLED = "ML Diagnostics disabled";
    public static final String UNSUPPORTED_BACKEND = "Backend not supported for ML Diagnostics";
    private WarningsContext.WarningType filter;

    public ResultsDiagnosticsTableExtractor() {
    }

    public ResultsDiagnosticsTableExtractor(WarningsContext.WarningType filter) {
        this.filter = filter;
    }

    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!model.backendType.supportsDiagnostics()) {
            return this.oneLineTable(UNSUPPORTED_BACKEND);
        }
        MLTask.DiagnosticsSettings settings = model.getCoreParams().diagnosticsSettings;
        if (settings == null || !settings.enabled) {
            return this.oneLineTable(ALL_DISABLED);
        }
        ArrayList<List<String>> diags = new ArrayList<List<String>>();
        Map<WarningsContext.WarningType, List<String>> groupedDiags = new HashMap<WarningsContext.WarningType, List<String>>();
        if (model.mlDiagnostics != null && model.mlDiagnostics.diagnostics != null && !model.mlDiagnostics.diagnostics.isEmpty()) {
            groupedDiags = model.mlDiagnostics.groupByType();
        }
        this.addDiagnostics(diags, settings, groupedDiags);
        return diags;
    }

    private List<List<String>> oneLineTable(String message) {
        ArrayList<List<String>> diags = new ArrayList<List<String>>();
        ArrayList<String> line = new ArrayList<String>();
        line.add("");
        line.add(message);
        diags.add(line);
        return diags;
    }

    private Optional<MLTask.DiagnosticSetting> getSetting(List<MLTask.DiagnosticSetting> settings, WarningsContext.WarningType type) throws IOException {
        for (MLTask.DiagnosticSetting setting : settings) {
            if (!setting.type.equals((Object)type)) continue;
            return Optional.of(setting);
        }
        return Optional.empty();
    }

    private void addDiagnostics(List<List<String>> diags, MLTask.DiagnosticsSettings settings, Map<WarningsContext.WarningType, List<String>> groupedDiags) throws IOException {
        for (MLDiagnostics.DiagnosticsTypes diagnosticType : MLDiagnostics.DiagnosticsTypes.values()) {
            WarningsContext.WarningType warningType = diagnosticType.warningType;
            if (this.filter != null && !warningType.equals((Object)this.filter)) continue;
            Optional<MLTask.DiagnosticSetting> setting = this.getSetting(settings.settings, warningType);
            ArrayList<String> row = new ArrayList<String>();
            row.add(diagnosticType.diagnosticDefinition.displayableType);
            if (setting.isPresent() && setting.get().enabled) {
                if (!groupedDiags.containsKey(warningType)) {
                    row.add(NOTHING_TO_REPORT);
                } else {
                    List<String> messages = groupedDiags.get(warningType);
                    row.add(String.join((CharSequence)"\n", messages));
                }
            } else {
                row.add(SINGLE_DISABLED);
            }
            diags.add(row);
        }
    }
}

