/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.interactivemodel;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelParams;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.Tuple3;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class InteractiveModelResultCache {
    public static final String CACHE_NAME = "dku.ml.interactivemodel.result";
    public static final String MAX_SIZE_CONFIG_KEY = "dku.caches.dku.ml.interactivemodel.result.maxSize";
    public static final String EXPIRATION_AFTER_ACCESS_MINUTES_CONFIG_KEY = "dku.caches.dku.ml.interactivemodel.result.expireAfterAccessMn";
    private static final int RESULT_CACHE_DEFAULT_EXPIRATION_TIME_IN_MINUTES = 60;
    private static final int RESULT_CACHE_DEFAULT_MAX_SIZE = 50;
    private final Cache<Tuple3<FullModelId, InteractiveModelParams.ComputationParams, JsonObject>, CachedValue> cache;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.ml.interactivemodel");

    public InteractiveModelResultCache() {
        Params p = DKUApp.getParams();
        long maxSize = p.getLongParam(MAX_SIZE_CONFIG_KEY, 50L);
        long expireAfterAccessMn = p.getLongParam(EXPIRATION_AFTER_ACCESS_MINUTES_CONFIG_KEY, 60L);
        logger.infoV("Init computation results cache with maxSize %d and expireAfterAccessMn %d", new Object[]{maxSize, expireAfterAccessMn});
        this.cache = CacheBuilder.newBuilder().recordStats().maximumSize(maxSize).expireAfterAccess(expireAfterAccessMn, TimeUnit.MINUTES).build();
        DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)CACHE_NAME, this.cache));
    }

    public void put(FullModelId fmi, InteractiveModelParams.ComputationParams computationParams, JsonObject record, InteractiveModelResponse.InteractiveModelResult result) {
        this.cache.put((Object)new Tuple3((Object)fmi, (Object)computationParams, (Object)record), (Object)new CachedValue(result));
    }

    public CachedValue get(FullModelId fmi, InteractiveModelParams.ComputationParams params, JsonObject record) {
        return (CachedValue)this.cache.getIfPresent((Object)new Tuple3((Object)fmi, (Object)params, (Object)record));
    }

    public void invalidateForModel(FullModelId fmi) {
        HashSet<Tuple3> filteredKeys = new HashSet<Tuple3>();
        for (Tuple3 key : this.cache.asMap().keySet()) {
            if (!((FullModelId)key._1).equals(fmi)) continue;
            filteredKeys.add(key);
        }
        this.cache.invalidateAll(filteredKeys);
    }

    @VisibleForTesting
    public long getCacheSize() {
        return this.cache.size();
    }

    public static class CachedValue {
        final InteractiveModelResponse.InteractiveModelResult value;

        CachedValue(InteractiveModelResponse.InteractiveModelResult value) {
            this.value = value;
        }
    }
}

