/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.analysis.ml.prediction.ModelDataUtilsService;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelEvaluationSampleDataService {
    @Autowired
    private ModelDataUtilsService modelDataUtilsService;
    TypeInferrer2 inferer = new TypeInferrer2();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.modelevaluation");

    public static String getSampleId(FullModelEvaluationId fme, SerializedShakerScript.ShakerExplorationSampleSettings sampling) {
        Object sampleId = fme.toString();
        logger.info((Object)("Compute sample id for " + (String)sampleId + " SAMPLING= " + JSON.json((Object)sampling)));
        sampleId = (String)sampleId + "-" + DigestUtils.md5Hex((String)JSON.json((Object)((Object)sampling.selection))) + sampling._refreshTrigger;
        return sampleId;
    }

    public synchronized MemScriptRunner.TableWithReport getUncachedFiltered_NT(FullModelEvaluationId fme, SerializedShakerScript script, FilterRequest filters) throws Exception {
        return this.getUncachedFiltered_NT(fme, script.explorationSampling, filters, script.sorting);
    }

    public synchronized MemScriptRunner.TableWithReport getUncachedFiltered_NT(FullModelEvaluationId fme, SerializedShakerScript.ShakerExplorationSampleSettings explorationSampling, FilterRequest filters, List<SerializedShakerScript.TableSorting> sorting) throws Exception {
        MemScriptRunner.TableWithReport twr = this.getUncachedUnfiltered_NT(fme, explorationSampling);
        this.modelDataUtilsService.applyFiltersAndSorts(twr, filters, sorting);
        return twr;
    }

    public synchronized MemScriptRunner.TableWithReport getUncachedUnfiltered_NT(FullModelEvaluationId fme, SerializedShakerScript.ShakerExplorationSampleSettings sampling) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Computing", (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            String sampleId = ModelEvaluationSampleDataService.getSampleId(fme, sampling);
            logger.info((Object)("Model evaluation sample disk sample id is " + sampleId));
            File sampleSchemaFile = fme.getEvaluationFile("sample_with_metrics_schema.json");
            if (!sampleSchemaFile.exists()) {
                throw new UnsupportedOperationException("Missing model evaluation sample schema in evaluationId " + fme.evaluationId + ". Try to run a new evaluation.");
            }
            Schema sampleSchema = (Schema)JSON.parseFile((File)sampleSchemaFile, Schema.class);
            long before = System.currentTimeMillis();
            MemScriptRunner.TableWithReport ret = new MemScriptRunner.TableWithReport();
            SampleBuilder.SampleMeta sampleToRead = SampleBuilder.getModelEvaluationSampleMeta(fme, sampleId);
            FutureProgress.updateState((double)1.0);
            if (sampleToRead != null) {
                logger.info((Object)"Disk sample cache hit");
            } else {
                logger.info((Object)"Disk sample cache miss");
                SampleBuilder.clearModelEvaluationSamples(fme);
                try (FutureProgress.AutocloseableFutureProgressState buildingState = FutureProgress.pushAutoCloseableState((String)"Building sample");){
                    SampleBuilder.buildModelEvaluationSample(fme, sampleId);
                }
                sampleToRead = SampleBuilder.getModelEvaluationSampleMeta(fme, sampleId);
            }
            assert (sampleToRead != null);
            FutureProgress.updateState((double)2.0);
            logger.info((Object)("Opening sample " + sampleId));
            ret.usedSample = sampleToRead;
            try (FutureProgress.AutocloseableFutureProgressState readingState = FutureProgress.pushAutoCloseableState((String)"Reading sample");){
                ret.table = SampleBuilder.readModelEvaluationSample(fme, sampleToRead.id);
                for (MemColumn cd : ret.table.columnsList) {
                    cd.datasetSchemaColumn = sampleSchema.getColumn(cd.getName());
                }
                ret.initialRows = ret.table.nrows();
                ret.initialCols = ret.table.ncols();
                logger.info((Object)("Reading sample done, read " + ret.table.nrows() + " rows"));
            }
            FutureProgress.updateState((double)3.0);
            ret.table.compact();
            FutureProgress.updateState((double)4.0);
            ret.warnings = new WarningsContext.SerializedWarnings();
            try (FutureProgress.AutocloseableFutureProgressState inferringState = FutureProgress.pushAutoCloseableState((String)"Detecting types");){
                String infererCacheKey = fme.toString() + JSON.json((Object)sampling);
                this.inferer.processFullAuto(infererCacheKey, ret.table);
            }
            FutureProgress.updateState((double)5.0);
            long inferDone = System.currentTimeMillis();
            logger.info((Object)("ModelEvaluationSampleDataService done time =  " + (inferDone - before)));
            MemScriptRunner.TableWithReport tableWithReport = ret;
            return tableWithReport;
        }
    }

    public DataService.ColumnDetailedAnalysis getDetailedColumnAnalysis(FullModelEvaluationId fme, SerializedShakerScript ss, String column, int alphanumMaxResults) throws Exception {
        MemTable table = this.getUncachedUnfiltered_NT((FullModelEvaluationId)fme, (SerializedShakerScript.ShakerExplorationSampleSettings)ss.explorationSampling).table;
        return this.modelDataUtilsService.getDetailedColumnAnalysis(table, ss, column, alphanumMaxResults);
    }
}

