/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.ModelVersioning;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionTrainingRecipeRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.DeepHubPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.PythonPredictionTrainRecipeSubrunner;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.core.PostTrainModelingParams;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.DeepHubPredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedDeepHubPredictionCoreParams;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DeepHubTrainingRecipeRunner
extends AbstractPredictionTrainingRecipeRunner {
    private DeepHubPredictionTrainingRecipePayloadParams desc;

    public DeepHubTrainingRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    protected ResolvedPreprocessingParams getPreprocessing() {
        return this.desc.preprocessing;
    }

    @Override
    protected PreTrainModelingParams getModeling() {
        return this.desc.modeling;
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (DeepHubPredictionTrainingRecipePayloadParams)JSON.parse((String)payload, DeepHubPredictionTrainingRecipePayloadParams.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void run() throws Exception {
        if (this.desc.backendType != MLTask.BackendType.DEEP_HUB) {
            throw new NotImplementedException("Unsupported backend type: " + String.valueOf((Object)this.desc.backendType));
        }
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)this.activity.getSubgraph();
        FlowSavedModel fsm = (FlowSavedModel)subgraph.getTargets().get(0);
        this.sm = fsm.getSavedModel();
        this.newVersionId = "" + System.currentTimeMillis();
        File outModelFolder = MLPaths.savedModelVersionFolder(this.sm, this.newVersionId);
        MLPaths.createIfNeededSavedModelFolderAndRestrictPermissions(this.sm);
        DKUFileUtils.mkdirs((File)outModelFolder);
        FullModelId newFMI = new FullModelId(this.sm.projectKey, this.sm.id, this.newVersionId);
        this.runFolder = outModelFolder;
        String projectKey = this.recipe.getProjectKey();
        ContainerExecSelection containerSelection = this.recipe.getModel().getParamsAs(ContainerRecipeParams.class).getContainerSelection();
        ContainerExecRuntimeConfig predictionContainerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(this.authCtxService.getAuthCtx(), projectKey, containerSelection, this.desc.backendType);
        File splitFolder = new File(outModelFolder, "split");
        DKUFileUtils.mkdirs((File)splitFolder);
        if (this.desc.script == null) {
            this.desc.script = new SerializedShakerScript();
        }
        SplitDesc splitDesc = this.predictionSplitService.prepareSplits(this.desc, splitFolder, false, this.newVersionId, subgraph);
        this.prepareModelFolder(outModelFolder, containerSelection, predictionContainerConfig, splitFolder, splitDesc);
        this.prepareTmpFolder(outModelFolder, predictionContainerConfig != null);
        JobContext.getCurrentActivitySummary().engineType = "DSS";
        InitializableAbortableRecipeRunner runner = this.createRunner(newFMI, outModelFolder, predictionContainerConfig, outModelFolder);
        this.startRunner(runner);
        MLDiagnostics.mergeIntoWarnings(new FullModelId(projectKey, this.sm.id, this.newVersionId), this.activity.warnContext);
        ModelTrainInfo mti = (ModelTrainInfo)JSON.parseFile((File)new File(outModelFolder, "train_info.json"), ModelTrainInfo.class);
        PostTrainModelingParams resolved = this.updateTrainInfoWithPostSearchDescription(outModelFolder, mti, this.desc.modeling);
        ModelVersioning.dumpTrainVersionInfo(this.desc.backendType, outModelFolder);
        List<FlowDataset> inputFDSs = subgraph.getSourceDatasetsForRole("main");
        Dataset inputDataset = inputFDSs.get(0).getMandatory(this.datasetsDAO);
        ModelUserMeta mum = this.createUserMeta(splitDesc.params, mti, this.desc.modelVersionNamePrefix, this.desc.modeling.generateName(), resolved.getAlgorithmName(), inputDataset.getFullName());
        if (this.desc.core.prediction_type == PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_OBJECT_DETECTION) {
            Optional<? extends DeepHubPredictionModelPerf> perf = FullModelId.getDeepHubPredictionPerf(outModelFolder);
            perf.ifPresent(p -> {
                mum.activeClassifierThreshold = p.optimalConfidenceScoreThreshold;
            });
        }
        JSON.prettyToFile((Object)mum, (File)new File(outModelFolder, "user_meta.json"));
        this.saveSavedModelOriginInfo(outModelFolder, this.desc.generatingModelId);
        JSON.prettyToFile((Object)inputDataset.getSchema(), (File)new File(outModelFolder, "input_dataset_schema.json"));
        this.activity.getTargetStatus((String)fsm.getFullId()).modelVersionId = this.newVersionId;
    }

    private InitializableAbortableRecipeRunner createRunner(FullModelId fmi, File outModelFolder, ContainerExecRuntimeConfig predictionContainerConfig, File modelFolder) {
        return new PythonPredictionTrainRecipeSubrunner(this.activity, fmi, outModelFolder, predictionContainerConfig, this.desc, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_TRAIN_DEEPHUB, "dataiku.doctor.deephub.launch_training_recipe", outModelFolder.getAbsolutePath());
    }

    private void prepareTmpFolder(File outModelFolder, boolean runsInContainer) throws IOException, DKUSecurityException, InterruptedException {
        String tmpFolderPath;
        if (!runsInContainer) {
            File tmpFolder = Files.createTempDirectory("deephub-prediction-training", new FileAttribute[0]).toFile();
            FilesystemACLUtils.grantFSFullACLs(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), tmpFolder);
            tmpFolderPath = tmpFolder.getAbsolutePath();
        } else {
            tmpFolderPath = ".";
        }
        JSON.prettyToFile(Collections.singletonMap("folder", tmpFolderPath), (File)new File(outModelFolder, "_etmp_folder_info.json"));
    }

    @Override
    protected ResolvedDeepHubPredictionCoreParams resolveCoreParams(ContainerExecSelection containerSelection) {
        ResolvedDeepHubPredictionCoreParams res = (ResolvedDeepHubPredictionCoreParams)JSON.deepCopy((Object)this.desc.core);
        this.addEnvParameters(this.desc, res, containerSelection);
        AnyLoc managedFolder = this.recipe.getModel().getSingleInput("data").getLoc(this.recipe.getProjectKey());
        res.managedFolderSmartId = managedFolder.getSmartName(this.recipe.getProjectKey());
        return res;
    }
}

