/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.vertica;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.ClusteringAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import java.util.ArrayList;
import java.util.List;

public class VerticaKMeansMeta
extends ClusteringAlgorithmMeta {
    @Override
    public MLTask.BackendType backendType() {
        return MLTask.BackendType.VERTICA;
    }

    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "KMeans (Vertica, k=" + rpmp.k + ")";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "";
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.VerticaKMeansParams km = task.modeling.vertica_kmeans_clustering;
        if (km.enabled) {
            for (int k : km.k) {
                for (double e : km.epsilon) {
                    PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.VERTICA_KMEANS);
                    rcmp.k = k;
                    rcmp.epsilon = e;
                    rcmp.max_iterations = km.max_iterations;
                    ret.add(new WorkSet.ModelingSet(rcmp));
                }
            }
        }
        return ret;
    }
}

