/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.ParameterChecks;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.preprocessing.FeatureGenerationParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TextFeaturePreprocessingParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class PreprocessingParams {
    public static final int MAXIMUM_WARNING_NB = 10;
    public Map<String, FeaturePreprocessingParams> per_feature = new HashMap<String, FeaturePreprocessingParams>();
    public FeatureGenerationParams feature_generation = new FeatureGenerationParams();

    public void validate(ParameterChecks checks) {
        this.feature_generation.validate(checks, this);
    }

    public void validateWindowsAndShifts(ParameterChecks checks, PredictionMLTask.TimeseriesForecastingMLTask task) {
        boolean atLeastOneAlgoSupportsShifts;
        boolean bl = atLeastOneAlgoSupportsShifts = task.modeling.xgboost.enabled || task.modeling.random_forest_regression.enabled || task.modeling.ridge_regression.enabled || task.modeling.lightgbm_regression.enabled;
        if (!atLeastOneAlgoSupportsShifts) {
            return;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        this.feature_generation.validateAutoShiftsParams(checks, warnings, this, task);
        this.feature_generation.validateShifts(warnings, this, task);
        this.feature_generation.validateWindows(checks, warnings, this, task);
        this.feature_generation.checkAtLeastOneWindowOrShift(warnings, this);
        if (!warnings.isEmpty()) {
            if (warnings.size() > 10) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 10; ++i) {
                    sb.append((String)warnings.get(i));
                    sb.append("\n");
                }
                sb.append("And ").append(warnings.size() - 10).append(" hidden warnings.");
                checks.addWarning("Time-aware feature generation", sb.toString());
            } else {
                checks.addWarning("Time-aware feature generation", String.join((CharSequence)"\n", warnings));
            }
        }
    }

    public Map<String, String> codeEnvSentenceEmbeddedFeaturesAndModels() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<String, FeaturePreprocessingParams> entry : this.per_feature.entrySet()) {
            FeaturePreprocessingParams featurePreprocessingParams = entry.getValue();
            if (!FeaturePreprocessingParams.Role.INPUT.equals((Object)featurePreprocessingParams.role) || !FeaturePreprocessingParams.FeatureType.TEXT.equals((Object)featurePreprocessingParams.type) || !(featurePreprocessingParams instanceof TextFeaturePreprocessingParams)) continue;
            TextFeaturePreprocessingParams textFeaturePreprocessingParams = (TextFeaturePreprocessingParams)featurePreprocessingParams;
            if (!TextFeaturePreprocessingParams.TextHandlingMethod.SENTENCE_EMBEDDING.equals((Object)textFeaturePreprocessingParams.text_handling) || textFeaturePreprocessingParams.sentenceEmbeddingModel == null || textFeaturePreprocessingParams.isStructuredRef) continue;
            res.put(entry.getKey(), textFeaturePreprocessingParams.sentenceEmbeddingModel);
        }
        return res;
    }
}

