/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class K8SAPIServiceDeployment
extends AbstractAPIServiceDockerDeployment {
    public String annotations;
    public List<SimpleKeyValue> properties = new ArrayList<SimpleKeyValue>();
    public Exposition serviceExposition = K8SAPIDeploymentInfra.makeDefaultExposition();
    public K8SAPIDeploymentInfra.K8SDeploymentScaling deploymentScaling = new K8SAPIDeploymentInfra.K8SDeploymentScaling();
    public K8SAPIDeploymentInfra.K8SDeploymentPodDisruptionBudget deploymentPodDisruptionBudget = new K8SAPIDeploymentInfra.K8SDeploymentPodDisruptionBudget();
    public String deploymentTopologySpreadConstraints;
    public K8SAPIDeploymentInfra.K8SYamlModifier deploymentModifier = new K8SAPIDeploymentInfra.K8SYamlModifier();
    public String serviceAccountName;
    public K8SAPIDeploymentInfra.K8SContainerLimits containerLimits = new K8SAPIDeploymentInfra.K8SContainerLimits();
    public K8SAPIDeploymentInfra.K8SAPINodeServerSizing apiNodeServerSizing = new K8SAPIDeploymentInfra.K8SAPINodeServerSizing();
    public JsonObject variables = new JsonObject();
    private List<SimpleKeyValue> additionalEnvVars = new ArrayList<SimpleKeyValue>();
    private List<SimpleKeyValue> additionalLabels = new ArrayList<SimpleKeyValue>();
    private List<SimpleKeyValue> additionalAnnotations = new ArrayList<SimpleKeyValue>();
    public K8SDeploymentOverrideMask overrideSettings = new K8SDeploymentOverrideMask();

    private K8SAPIServiceDeployment() {
    }

    public K8SAPIServiceDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag) {
        super(id, infraId, publishedServiceId, version, enabled, creationTag);
    }

    public K8SAPIServiceDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag, List<AbstractAPIServiceDeployment.AuthorizationItem> authorizationsToQueryThroughDeployer) {
        super(id, infraId, publishedServiceId, version, enabled, creationTag, authorizationsToQueryThroughDeployer);
    }

    public K8SAPIServiceDeployment(AbstractAPIServiceDeployment existingDeployment, String deploymentId, String infraId, boolean enabled, VersionTag creationTag) {
        super(existingDeployment, deploymentId, infraId, enabled, creationTag);
    }

    @Nonnull
    public static K8SAPIServiceDeployment buildDefault(String deploymentId, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag, List<AbstractAPIServiceDeployment.AuthorizationItem> authorizationsToQueryThroughDeployer, GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings cloudSettings) {
        K8SAPIServiceDeployment deployment = new K8SAPIServiceDeployment(deploymentId, infraId, publishedServiceId, version, enabled, creationTag, authorizationsToQueryThroughDeployer);
        if (DKUApp.isDataikuCloud()) {
            deployment.apiNodeServerSizing = cloudSettings.serverSizing;
            deployment.containerLimits = cloudSettings.containerLimits;
            deployment.deploymentScaling = cloudSettings.deploymentScaling;
        }
        return deployment;
    }

    public Collection<SimpleKeyValue> getAdditionalEnvVars(K8SAPIDeploymentInfra infra) {
        if (infra.allowAdditionalEnvVarsInDeployments) {
            return K8SAPIServiceDeployment.getSimpleKeyValues(this.additionalEnvVars, infra.additionalEnvVars, true);
        }
        return infra.additionalEnvVars;
    }

    public Collection<SimpleKeyValue> getAdditionalLabels(K8SAPIDeploymentInfra infra) {
        if (infra.allowAdditionalLabelsInDeployments) {
            return K8SAPIServiceDeployment.getSimpleKeyValues(this.additionalLabels, infra.additionalLabels, true);
        }
        return infra.additionalLabels;
    }

    public Collection<SimpleKeyValue> getAdditionalAnnotations(K8SAPIDeploymentInfra infra) {
        if (infra.allowAdditionalAnnotationsInDeployments) {
            return K8SAPIServiceDeployment.getSimpleKeyValues(this.additionalAnnotations, infra.additionalAnnotations, true);
        }
        return infra.additionalAnnotations;
    }

    public String getServiceAccountName(K8SAPIDeploymentInfra infra) {
        if (infra.allowOverridingServiceAccountNameInDeployments) {
            return this.serviceAccountName;
        }
        return infra.serviceAccountName;
    }

    @Override
    public K8SDeploymentOverrideMask getOverrideSettings() {
        return this.overrideSettings;
    }

    @Override
    public void prepareInstallIni(AbstractAPIDockerDeploymentInfra infra, File contextDir) throws IOException {
        File installFolder = new File(contextDir, "install-details");
        DKUFileUtils.mkdirs((File)installFolder);
        Object installIni = String.format("[javaopts]\napimain.xmx=%s\napimain.gc=%s\n", this.apiNodeServerSizing.apimainXmx, this.apiNodeServerSizing.apimainGC);
        if (StringUtils.isNotBlank((String)this.apiNodeServerSizing.apimainAdditionalOpts)) {
            installIni = (String)installIni + "apimain.additional.opts=" + this.apiNodeServerSizing.apimainAdditionalOpts + "\n";
        }
        installIni = (String)installIni + "\n\n";
        installIni = (String)installIni + "[supervisord]\n";
        installIni = (String)installIni + "kill_supervisord_if_child_dies_agressive = true\n";
        AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging nodeLogging = this.getNodeLogging(infra);
        if (nodeLogging.redirectToPod) {
            installIni = (String)installIni + "\n\n";
            installIni = (String)installIni + "[logs]\n";
            installIni = (String)installIni + "redirect_to_supervisor_stdout = true\n";
        }
        DKUFileUtils.writeFileUTF8((File)new File(installFolder, "install.ini.add"), (String)installIni);
    }

    @Override
    public void additionalFinalizeForDeploymentType(File contextDir, AbstractAPIDeploymentInfra infra) throws IOException {
        File additionalTargetInit = new File(contextDir, "Docker.additional_finalize_deployment_type");
        StringBuilder builder = new StringBuilder();
        builder.append("USER root\n");
        builder.append("RUN chmod 755 /usr/local/bin/docker-entrypoint.sh\n");
        if (((K8SAPIDeploymentInfra)infra).enableOpenshiftCompatibility) {
            builder.append("RUN chown -Rh dataiku:0 /home/dataiku && chmod -R 775 /home/dataiku\n");
        }
        String uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
        builder.append("USER " + uid + "\n");
        builder.append("ENTRYPOINT [\"/usr/local/bin/docker-entrypoint.sh\"]\n");
        builder.append("EXPOSE 12000\n");
        DKUFileUtils.writeFileUTF8((File)additionalTargetInit, (String)builder.toString());
    }

    public static class K8SDeploymentOverrideMask
    extends AbstractAPIServiceDockerDeployment.APIServiceDockerDeploymentOverrideMask {
        public boolean deploymentScaling;
        public boolean podSetup;
        public boolean containerLimits;
        public boolean apiNodeServerSizing;
        public boolean serviceExposition;

        public void applyToDeployment(K8SAPIServiceDeployment target, K8SAPIDeploymentInfra source) {
            super.applyToDeployment(target, source);
            if (!this.serviceExposition) {
                target.serviceExposition = (Exposition)JSON.deepCopy((Object)source.defaultServiceExposition);
            }
            if (!this.deploymentScaling) {
                target.deploymentScaling = (K8SAPIDeploymentInfra.K8SDeploymentScaling)JSON.deepCopy((Object)source.defaultDeploymentScaling);
                target.deploymentPodDisruptionBudget = (K8SAPIDeploymentInfra.K8SDeploymentPodDisruptionBudget)JSON.deepCopy((Object)source.defaultDeploymentPodDisruptionBudget);
                target.deploymentTopologySpreadConstraints = source.defaultDeploymentTopologySpreadConstraints;
            }
            if (!this.podSetup) {
                target.serviceAccountName = source.serviceAccountName;
                target.deploymentModifier = (K8SAPIDeploymentInfra.K8SYamlModifier)JSON.deepCopy((Object)source.defaultDeploymentModifier);
            }
            if (!this.containerLimits) {
                target.containerLimits = (K8SAPIDeploymentInfra.K8SContainerLimits)JSON.deepCopy((Object)source.defaultContainerLimits);
            }
            if (!this.apiNodeServerSizing) {
                target.apiNodeServerSizing = (K8SAPIDeploymentInfra.K8SAPINodeServerSizing)JSON.deepCopy((Object)source.defaultApiNodeServerSizing);
            }
        }
    }
}

