/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments.actions;

import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.AbstractDeploymentsService;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentAction;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import javax.annotation.Nullable;

public class DeploymentDeletion
extends DeploymentAction {
    @Nullable
    private final AbstractDeploymentsService.DeploymentDeletionReport report;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actions.deletion");

    private DeploymentDeletion() {
        this.report = null;
    }

    protected DeploymentDeletion(boolean inProgress, long startTimestamp, @Nullable Long endTimestamp, PublicUser requester, @Nullable InfoMessage.Severity status, @Nullable AbstractDeploymentsService.DeploymentDeletionReport report, AbstractDeploymentInfra infra, AbstractDeployment deployment) {
        super(inProgress, startTimestamp, endTimestamp, requester, status, infra, deployment);
        this.report = report;
    }

    public static DeploymentDeletion initiated(PublicUser requester, AbstractDeploymentInfra infra, AbstractDeployment deployment, long startTimestamp) {
        return new DeploymentDeletion(true, startTimestamp, null, requester, null, null, infra, deployment);
    }

    public static DeploymentDeletion completed(DeploymentDeletion deletionToComplete, InfoMessage.Severity status, @Nullable AbstractDeploymentsService.DeploymentDeletionReport report, long endTimestamp) {
        return new DeploymentDeletion(false, deletionToComplete.getStartTimestamp(), endTimestamp, deletionToComplete.getRequester(), status, report, deletionToComplete.getInfra(), deletionToComplete.getDeployment());
    }

    @Override
    public String getType() {
        return "DELETE";
    }

    @Override
    @Nullable
    public AbstractDeploymentsService.DeploymentDeletionReport getReport() {
        return this.report;
    }

    @Override
    public DeploymentDeletion completeAction(@Nullable Object report, long endTimestamp) {
        if (report == null) {
            return DeploymentDeletion.completed(this, InfoMessage.Severity.ERROR, null, endTimestamp);
        }
        if (report instanceof AbstractDeploymentsService.DeploymentDeletionReport) {
            AbstractDeploymentsService.DeploymentDeletionReport deletionReport = (AbstractDeploymentsService.DeploymentDeletionReport)report;
            InfoMessage.Severity status = deletionReport.hasFailure() ? InfoMessage.Severity.ERROR : InfoMessage.Severity.SUCCESS;
            return DeploymentDeletion.completed(this, status, deletionReport, endTimestamp);
        }
        logger.errorV("Wrong report type. Expected %s, got: %s", new Object[]{AbstractDeploymentsService.DeploymentDeletionReport.class.getName(), report.getClass().getName()});
        throw ErrorContext.iae((String)"Couldn't complete the deployment deletion action due to the invalid report type");
    }
}

