/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.runtime.CodeStudioSyncZones;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DSSBaseImageCodeStudioBlockMeta
implements CodeStudioBlockMeta {
    public static final String WORKSPACE_PATH = "/home/dataiku/workspace";
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.block.base");

    @Override
    public String getType() {
        return "dss_base_image";
    }

    @Override
    public void newTemplateInitialization(CodeStudioBlock block) {
        DSSBaseImageCodeStudioBlockParams params = block.getParamsAs(DSSBaseImageCodeStudioBlockParams.class);
        for (CodeStudioSyncZones.SyncZone zone : CodeStudioSyncZones.all()) {
            params.syncedZones.add(zone.defaultWithPrefix("/home/dataiku/workspace/"));
        }
    }

    @Override
    public Class<? extends CodeStudioBlockParams> blockParamsClass() {
        return DSSBaseImageCodeStudioBlockParams.class;
    }

    @Override
    public CodeStudioBlock.CodeStudioBlockType getBlockType() {
        CodeStudioBlock.CodeStudioBlockType ret = new CodeStudioBlock.CodeStudioBlockType();
        ret.type = this.getType();
        ret.label = "File synchronization";
        ret.description = "Files synchronized from the DSS instance to the Code Studio. Default layout inside the Code Studio is from the DSS base image (centos-based, with 'dataiku' user)";
        ret.isUnique = true;
        ret.isLocked = true;
        ret.isAdvanced = false;
        ret.uiDisplayPriority = 0;
        return ret;
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.ImageBuildSpec buildSpec, CodeStudioMeta.ImageBuildEnv buildEnv, CodeStudioTemplate template) throws IOException {
        DSSBaseImageCodeStudioBlockParams params = block.getParamsAs(DSSBaseImageCodeStudioBlockParams.class);
        ArrayList lines = Lists.newArrayList();
        lines.add("##### BASE IMAGE BLOCK #####\n");
        lines.add("FROM __CONTAINER_CONFIG_BASE_IMAGE__");
        buildSpec.dockerfile = Joiner.on((String)"\n").join((Iterable)lines);
        buildSpec.syncedZones = Lists.newArrayList(params.syncedZones);
        if (buildSpec.syncedZones.stream().anyMatch(z -> z.pathInContainer.startsWith(WORKSPACE_PATH))) {
            String uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
            buildSpec.dockerfile = buildSpec.dockerfile + "\n\nUSER root";
            buildSpec.dockerfile = buildSpec.dockerfile + "\n\nRUN mkdir -p /home/dataiku/workspace";
            buildSpec.dockerfile = buildSpec.dockerfile + "\nRUN chown dataiku:dataiku /home/dataiku/workspace";
            DSSBaseImageCodeStudioBlockMeta.copyResourceToWorkspaceRoot(buildSpec, buildEnv, "workspace_sync_folders_README.md", "CodeStudio_README.md");
            buildSpec.dockerfile = buildSpec.dockerfile + "\n\nUSER " + uid;
            buildSpec.dockerfile = buildSpec.dockerfile + "\nWORKDIR /home/dataiku";
            buildSpec.dockerfile = buildSpec.dockerfile + "\nENV LC_ALL=en_US.UTF-8";
        }
        return buildSpec;
    }

    private static void copyResourceToWorkspaceRoot(CodeStudioMeta.ImageBuildSpec buildSpec, CodeStudioMeta.ImageBuildEnv buildEnv, String sourceFileName, String destFileName) throws IOException {
        File dssReadme = DKUApp.getResourceFile((String[])new String[]{"code-studios", sourceFileName});
        File dockerReadme = new File(buildEnv.buildDir, sourceFileName);
        if (!dockerReadme.exists()) {
            FileUtils.copyFile((File)dssReadme, (File)dockerReadme);
        } else {
            logger.warn((Object)(sourceFileName + " already exist in build dir " + buildEnv.buildDir));
        }
        buildSpec.dockerfile = buildSpec.dockerfile + "\nCOPY " + sourceFileName + " /home/dataiku/workspace/" + destFileName;
        buildSpec.dockerfile = buildSpec.dockerfile + "\nRUN chown dataiku:dataiku /home/dataiku/workspace/" + destFileName;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CodeStudioLaunchSpec launchSpec, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) {
        DSSBaseImageCodeStudioBlockParams params = block.getParamsAs(DSSBaseImageCodeStudioBlockParams.class);
        launchSpec.syncedZones = Lists.newArrayList(params.syncedZones);
        launchSpec.excludedFromSync = params.excludedFromSync;
        launchSpec.fileAdjustmentScript = params.fileAdjustmentScript;
        return launchSpec;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportBlock(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.TemplateExportSpec exportSpec) {
        return exportSpec;
    }

    @Override
    public CodeStudioBlock importBlock(AuthCtx authCtx, CodeStudioBlock srcBlock, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) {
        return srcBlock;
    }

    @Override
    public CodeStudioMeta.CreationSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CreationSpec creationSpec, CodeStudioMeta.CreationEnv creationEnv) throws IOException, DKUSecurityException {
        return creationSpec;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioBlock block, CodeStudioTemplate template) {
        return Lists.newArrayList();
    }

    public static class DSSBaseImageCodeStudioBlockParams
    implements CodeStudioBlockParams {
        public List<CodeStudioMeta.SyncZoneInstance> syncedZones = Lists.newArrayList();
        public List<String> excludedFromSync = Lists.newArrayList();
        public String fileAdjustmentScript;

        @Override
        public void checkValid(VariablesContext templateVariablesContext) throws Exception {
            HashMap<String, String> folderKindPerPath = new HashMap<String, String>();
            for (CodeStudioMeta.SyncZoneInstance synced : this.syncedZones) {
                this.checkDupe(synced.pathInContainer, synced.zone, folderKindPerPath);
            }
        }

        private void checkDupe(String path, String folderKind, Map<String, String> folderKindPerPath) {
            if (StringUtils.isBlank((String)path)) {
                return;
            }
            String existingKind = folderKindPerPath.getOrDefault(path, "");
            if (StringUtils.isNotBlank((String)existingKind)) {
                throw ErrorContext.ice((String)(existingKind + " and " + folderKind + " must use different paths in container."));
            }
            folderKindPerPath.put(path, folderKind);
        }
    }
}

