/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StarterFilesBlockMeta
implements CodeStudioBlockMeta {
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.block.starter");

    @Override
    public String getType() {
        return "starter_files";
    }

    @Override
    public void newTemplateInitialization(CodeStudioBlock block) {
    }

    @Override
    public Class<? extends CodeStudioBlockParams> blockParamsClass() {
        return StarterFilesBlockParams.class;
    }

    @Override
    public CodeStudioBlock.CodeStudioBlockType getBlockType() {
        CodeStudioBlock.CodeStudioBlockType ret = new CodeStudioBlock.CodeStudioBlockType();
        ret.type = this.getType();
        ret.label = "Add Starter Files";
        ret.description = "Define a set of files that Code Studios are created with";
        ret.isLocked = false;
        ret.isUnique = false;
        ret.icon = "icon-copy";
        ret.isAdvanced = true;
        ret.uiDisplayPriority = 1010;
        return ret;
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.ImageBuildSpec buildSpec, CodeStudioMeta.ImageBuildEnv buildEnv, CodeStudioTemplate template) throws IOException {
        return buildSpec;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CodeStudioLaunchSpec launchSpec, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) throws IOException {
        return launchSpec;
    }

    private static void exportBlockZone(List<SimpleKeyValue> files, CodeStudioMeta.TemplateExportSpec exportSpec) {
        for (SimpleKeyValue file : files) {
            if (CodeStudioTemplatesService.isInTemplateResourcesDir(file.key)) continue;
            CodeStudioMeta.TemplateExportResource exportResource = new CodeStudioMeta.TemplateExportResource();
            exportResource.localPath = file.key;
            exportSpec.resourcesMap.put(file.key, exportResource);
        }
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportBlock(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.TemplateExportSpec exportSpec) {
        StarterFilesBlockParams params = block.getParamsAs(StarterFilesBlockParams.class);
        StarterFilesBlockMeta.exportBlockZone(params.codeStudioVersionedFiles, exportSpec);
        StarterFilesBlockMeta.exportBlockZone(params.codeStudioResourcesFiles, exportSpec);
        StarterFilesBlockMeta.exportBlockZone(params.userVersionedFiles, exportSpec);
        StarterFilesBlockMeta.exportBlockZone(params.userResourcesFiles, exportSpec);
        StarterFilesBlockMeta.exportBlockZone(params.codeStudioVersionedFiles, exportSpec);
        return exportSpec;
    }

    private static void importBlockZone(List<SimpleKeyValue> files, CodeStudioMeta.TemplateExportSpec exportSpec) {
        for (SimpleKeyValue file : files) {
            if (CodeStudioTemplatesService.isInTemplateResourcesDir(file.key)) continue;
            CodeStudioMeta.TemplateExportResource exportResource = exportSpec.resourcesMap.get(file.key);
            if (exportResource == null) {
                throw new IllegalArgumentException("Resource missing from export " + file.key);
            }
            file.key = exportResource.localPath;
        }
    }

    @Override
    public CodeStudioBlock importBlock(AuthCtx authCtx, CodeStudioBlock srcBlock, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) {
        CodeStudioBlock block = (CodeStudioBlock)JSON.deepCopy((Object)srcBlock);
        StarterFilesBlockParams params = block.getParamsAs(StarterFilesBlockParams.class);
        StarterFilesBlockMeta.importBlockZone(params.codeStudioVersionedFiles, exportSpec);
        StarterFilesBlockMeta.importBlockZone(params.codeStudioResourcesFiles, exportSpec);
        StarterFilesBlockMeta.importBlockZone(params.userVersionedFiles, exportSpec);
        StarterFilesBlockMeta.importBlockZone(params.userResourcesFiles, exportSpec);
        StarterFilesBlockMeta.importBlockZone(params.codeStudioVersionedFiles, exportSpec);
        return block;
    }

    @Override
    public CodeStudioMeta.CreationSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CreationSpec creationSpec, CodeStudioMeta.CreationEnv creationEnv) throws IOException, DKUSecurityException {
        StarterFilesBlockParams params = block.getParamsAs(StarterFilesBlockParams.class);
        VariablesContext vc = CodeStudioTemplatesService.getTemplateVariablesContext(creationEnv.codeStudio.templateId);
        File tmpDir = new File(creationEnv.tmpDir);
        this.copyToTmpDir(params.codeStudioVersionedFiles, creationSpec.codeStudioVersionedFiles, "code_studio_versioned", vc, tmpDir);
        this.copyToTmpDir(params.codeStudioResourcesFiles, creationSpec.codeStudioResourcesFiles, "code_studio_resources", vc, tmpDir);
        this.copyToTmpDir(params.userVersionedFiles, creationSpec.userVersionedFiles, "user_versioned", vc, tmpDir);
        this.copyToTmpDir(params.userResourcesFiles, creationSpec.userResourcesFiles, "user_resources", vc, tmpDir);
        return creationSpec;
    }

    private void copyToTmpDir(List<SimpleKeyValue> sourceCopies, List<SimpleKeyValue> targetCopies, String type, VariablesContext templateVariablesContext, File tmpDir) throws FileNotFoundException, IOException {
        int n = 0;
        String tmpDirLNT = PathUtils.makeLeadingNoTrailing((String)tmpDir.getAbsolutePath());
        for (SimpleKeyValue copy : sourceCopies) {
            File from = CodeStudioTemplatesService.getReadableFileOrThrow(copy.key, templateVariablesContext, "Starter file");
            File to = new File(tmpDir, type + "_" + n++);
            to = new File(to, from.getName());
            logger.info((Object)("Copying " + from.getAbsolutePath() + " to " + to.getAbsolutePath()));
            if (from.isDirectory()) {
                DKUFileUtils.copyDirectory((File)from, (File)to);
            } else {
                FileUtils.copyFile((File)from, (File)to);
                if (!to.setExecutable(from.canExecute())) {
                    logger.warn((Object)("Cannot set execute permission on" + to.getName()));
                }
            }
            String newSource = PathUtils.makeLeadingNoTrailing((String)to.getAbsolutePath());
            targetCopies.add(new SimpleKeyValue(newSource.substring(tmpDirLNT.length() + 1), copy.value));
        }
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioBlock block, CodeStudioTemplate template) {
        return Lists.newArrayList();
    }

    public static class StarterFilesBlockParams
    implements CodeStudioBlockParams {
        public List<SimpleKeyValue> codeStudioVersionedFiles = Lists.newArrayList();
        public List<SimpleKeyValue> codeStudioResourcesFiles = Lists.newArrayList();
        public List<SimpleKeyValue> userVersionedFiles = Lists.newArrayList();
        public List<SimpleKeyValue> userResourcesFiles = Lists.newArrayList();

        @Override
        public void checkValid(VariablesContext templateVariablesContext) throws Exception {
            for (SimpleKeyValue file : this.codeStudioVersionedFiles) {
                if (StringUtils.isBlank((String)file.key)) {
                    throw ErrorContext.ice((String)"Code Studio versioned source file cannot be empty");
                }
                if (StringUtils.isBlank((String)file.value)) {
                    throw ErrorContext.ice((String)"Code Studio versioned target file cannot be empty");
                }
                CodeStudioTemplatesService.getReadableFileOrThrow(file.key, templateVariablesContext, "Starter file");
            }
            for (SimpleKeyValue file : this.codeStudioResourcesFiles) {
                if (StringUtils.isBlank((String)file.key)) {
                    throw ErrorContext.ice((String)"Code Studio resource source file cannot be empty");
                }
                if (StringUtils.isBlank((String)file.value)) {
                    throw ErrorContext.ice((String)"Code Studio resource target file cannot be empty");
                }
                CodeStudioTemplatesService.getReadableFileOrThrow(file.key, templateVariablesContext, "Starter file");
            }
            for (SimpleKeyValue file : this.userVersionedFiles) {
                if (StringUtils.isBlank((String)file.key)) {
                    throw ErrorContext.ice((String)"User config source file cannot be empty");
                }
                if (StringUtils.isBlank((String)file.value)) {
                    throw ErrorContext.ice((String)"User config target file cannot be empty");
                }
                CodeStudioTemplatesService.getReadableFileOrThrow(file.key, templateVariablesContext, "Starter file");
            }
            for (SimpleKeyValue file : this.userResourcesFiles) {
                if (StringUtils.isBlank((String)file.key)) {
                    throw ErrorContext.ice((String)"User resource source file cannot be empty");
                }
                if (StringUtils.isBlank((String)file.value)) {
                    throw ErrorContext.ice((String)"User resource target file cannot be empty");
                }
                CodeStudioTemplatesService.getReadableFileOrThrow(file.key, templateVariablesContext, "Starter file");
            }
        }
    }
}

