/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.identity.spi.AwsSessionCredentialsIdentity;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class AWSCredentialsHelper {
    public static final String AWS_ACCESS_KEY_ID = "AWS_ACCESS_KEY_ID";
    public static final String AWS_SECRET_ACCESS_KEY = "AWS_SECRET_ACCESS_KEY";
    public static final String AWS_SESSION_TOKEN = "AWS_SESSION_TOKEN";
    public static final String AWS_DEFAULT_REGION = "AWS_DEFAULT_REGION";
    private static Cache<String, ConnectionWithAWSAuthCredentials.SerializableAWSCredential> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).recordStats().build();
    private static final DKULogger logger;

    private static String assumeCacheKey(AuthCtx authCtx, String assumedRole, String duration, String externalId, String regionOrEndpoint) {
        return "assumed_" + authCtx.getIdentifier() + "___" + assumedRole + "___" + duration + "___" + externalId + "___" + regionOrEndpoint;
    }

    public static ConnectionWithAWSAuthCredentials.SerializableAWSCredential getCredentialForAssumeRole(AuthCtx authCtx, String connectionName, String stsRoleToAssume, String stsAssumeExternalId, String stsAssumeDurationSeconds, String stsEndpoint, VariablesContext vc) {
        int durationInt;
        boolean cacheEnabled = DKUApp.getParams().getBoolParam("dku.aws.credentials.assumeRoleTokensCache.enabled", true);
        AWSClientBrokerService awsClientBrokerService = (AWSClientBrokerService)SpringUtils.getBean(AWSClientBrokerService.class);
        String role = vc.expand(stsRoleToAssume);
        String externalId = vc.expand(stsAssumeExternalId);
        String duration = vc.expand(stsAssumeDurationSeconds);
        String cacheKey = AWSCredentialsHelper.assumeCacheKey(authCtx, role, stsAssumeDurationSeconds, stsAssumeExternalId, StringUtils.defaultIfBlank((String)stsEndpoint, (String)"global"));
        logger.infoV("AWS connection=%s authCtx=%s assuming role=%s", new Object[]{connectionName, authCtx.getIdentifier(), role});
        if (cacheEnabled) {
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential ret = (ConnectionWithAWSAuthCredentials.SerializableAWSCredential)cache.getIfPresent((Object)cacheKey);
            if (ret != null) {
                logger.debug((Object)"Credentials cache hit");
                return ret;
            }
            logger.debug((Object)"Credentials cache miss");
        }
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        AwsCredentials creds = credentialsProvider.resolveCredentials();
        logger.debug((Object)("Using context creds access=" + creds.accessKeyId()));
        StsClient sts = awsClientBrokerService.createStsClient((AwsCredentialsProvider)credentialsProvider, stsEndpoint);
        String roleSessionName = "dss-conn-" + connectionName + "-assumed-for-" + authCtx.getIdentifier();
        Object cleanRoleSessionName = roleSessionName.replaceAll("[^\\w+=,.@-]", "_");
        if (!((String)cleanRoleSessionName).equals(roleSessionName) || ((String)cleanRoleSessionName).length() > 64) {
            cleanRoleSessionName = ((String)cleanRoleSessionName).substring(0, Math.min(((String)cleanRoleSessionName).length(), 55)) + "-" + SecretKeyGenerator.generate((int)8);
            logger.debug((Object)("Truncated/slugified session name to 64 chars: " + (String)cleanRoleSessionName));
        }
        AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleArn(role).roleSessionName((String)cleanRoleSessionName);
        if (StringUtils.isNotBlank((String)duration)) {
            logger.debug((Object)("Using duration=" + duration));
            durationInt = Integer.parseInt(duration);
            assumeRoleRequestBuilder.durationSeconds(Integer.valueOf(durationInt));
        } else {
            durationInt = 900;
        }
        if (StringUtils.isNotBlank((String)externalId)) {
            logger.debug((Object)("Using externalId=" + externalId));
            assumeRoleRequestBuilder.externalId(externalId);
        }
        AssumeRoleResponse arr = sts.assumeRole((AssumeRoleRequest)assumeRoleRequestBuilder.build());
        logger.debug((Object)"Got assumed role credentials from STS");
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential c2 = new ConnectionWithAWSAuthCredentials.SerializableAWSCredential(arr.credentials().accessKeyId(), arr.credentials().secretAccessKey(), arr.credentials().sessionToken());
        c2.withExpirationTime(System.currentTimeMillis() + (long)(durationInt * 1000));
        if (cacheEnabled) {
            logger.debug((Object)"Caching assumed STS credential");
            cache.put((Object)cacheKey, (Object)c2);
        }
        return c2;
    }

    public static ConnectionWithAWSAuthCredentials.SerializableAWSCredential getCredentialsFromEnvironment() {
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential ret = new ConnectionWithAWSAuthCredentials.SerializableAWSCredential();
        DefaultCredentialsProvider defaultCredentialsProvider = DefaultCredentialsProvider.create();
        AwsCredentials credentials = defaultCredentialsProvider.resolveCredentials();
        ret.accessKey = credentials.accessKeyId();
        ret.secretKey = credentials.secretAccessKey();
        if (credentials instanceof AwsSessionCredentialsIdentity) {
            ret.sessionToken = ((AwsSessionCredentialsIdentity)credentials).sessionToken();
        }
        return ret;
    }

    public static void toEnv(AwsCredentials credentials, Map<String, String> additionalEnv, String region) {
        if (credentials instanceof AwsSessionCredentials && StringUtils.isNotEmpty((String)((AwsSessionCredentials)credentials).sessionToken())) {
            additionalEnv.put(AWS_SESSION_TOKEN, ((AwsSessionCredentials)credentials).sessionToken());
        }
        if (StringUtils.isNotEmpty((String)credentials.accessKeyId())) {
            additionalEnv.put(AWS_ACCESS_KEY_ID, credentials.accessKeyId());
        }
        if (StringUtils.isNotEmpty((String)credentials.secretAccessKey())) {
            additionalEnv.put(AWS_SECRET_ACCESS_KEY, credentials.secretAccessKey());
        }
        if (StringUtils.isNotEmpty((String)region)) {
            additionalEnv.put(AWS_DEFAULT_REGION, region);
        }
    }

    static {
        DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)"aws.credentials", cache));
        logger = DKULogger.getLogger((String)"dku.aws.credentials");
    }
}

